/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.DB;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class StopStartLogShipping
extends Command {
    static Logger logger = Logger.getLogger(StopStartLogShipping.class.getName());
    private final DBCommandActionType type;
    private final Strategy strat;

    public StopStartLogShipping(ActionType automationAction, DBCommandActionType type, Strategy strat) {
        super(automationAction);
        assert (DBCommandActionType.StartLogShipping.equals((Object)type) || DBCommandActionType.StopLogShipping.equals((Object)type));
        this.type = type;
        this.strat = strat;
    }

    private List<ExecutionStep.Command> getLogShippingCommand(ExecutionStep es, boolean usingBorker, AbstractBaseTarget primary) {
        ArrayList<ExecutionStep.Command> executionCmds = new ArrayList<ExecutionStep.Command>();
        String dbName = null;
        OracleHome oracleHome = null;
        if (primary instanceof SIDatabase) {
            logger.info("The Primary database is SI database");
            SIDatabase siDB = (SIDatabase)primary;
            oracleHome = siDB.getRuns_from();
            dbName = siDB.getName();
        } else if (primary instanceof RACDatabase) {
            logger.info("The Primary database is RAC database");
            RACDatabase racDB = (RACDatabase)primary;
            dbName = racDB.getName();
            List racInsts = racDB.getDbInstances();
            if (racInsts != null && racInsts.size() > 0) {
                oracleHome = ((RACDBInstance)racInsts.get(0)).getRuns_from();
            }
        } else {
            throw new PatchPlanException("Target is not database");
        }
        String OracleSid = DBCommandUtils.getOracleSID(es, primary);
        if (oracleHome != null) {
            String cmd;
            if (usingBorker) {
                logger.info("Data guard broker is configed");
                cmd = "ORACLE_HOME=" + oracleHome.getPath() + " ORACLE_SID=" + OracleSid + " " + oracleHome.getPath() + "/bin/dgmgrl /";
                executionCmds.add(new ExecutionStep.Command(cmd));
                String dgmgrlCommand = "";
                if (DBCommandActionType.StopLogShipping.equals((Object)this.type)) {
                    dgmgrlCommand = "edit database " + dbName + " set state='LOG-TRANSPORT-OFF';";
                } else if (DBCommandActionType.StartLogShipping.equals((Object)this.type)) {
                    dgmgrlCommand = "edit database " + dbName + " set state='ONLINE';";
                }
                ExecutionStep.Command dgmgrlCmd = new ExecutionStep.Command(dgmgrlCommand, ExecutionStep.Command.CommandType.DGMGRL);
                executionCmds.add(dgmgrlCmd);
            } else {
                logger.info("Data guard broker have not been configed");
                cmd = "ORACLE_HOME=" + oracleHome.getPath() + " ORACLE_SID=" + OracleSid + " " + oracleHome.getPath() + "/bin/sqlplus / as sysdba";
                executionCmds.add(new ExecutionStep.Command(cmd));
                String sqlCommand = "";
                if (DBCommandActionType.StopLogShipping.equals((Object)this.type)) {
                    sqlCommand = "alter system set log_archive_dest_state_2=defer scope=both;";
                } else if (DBCommandActionType.StartLogShipping.equals((Object)this.type)) {
                    sqlCommand = "alter system set log_archive_dest_state_2=enable scope=both;";
                }
                ExecutionStep.Command sqlCmd = new ExecutionStep.Command(sqlCommand, ExecutionStep.Command.CommandType.SQL);
                executionCmds.add(sqlCmd);
            }
        }
        return executionCmds;
    }

    @Override
    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            List secondaryDB;
            assert (abstractBaseTarget instanceof RACDatabase);
            if (!(abstractBaseTarget instanceof RACDatabase)) {
                throw new PatchPlanException("StopStartlogshipping action can act only on RACDBInstance, but found: " + abstractBaseTarget.getClass().getName());
            }
            RACDatabase db = (RACDatabase)abstractBaseTarget;
            CommandContext cc = contextPopulator.populateContext(g, abstractBaseTarget, this.getHost());
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(cc);
            }
            if (db.getDataguardStatus() != null && db.getDataguardStatus().toLowerCase().contains("standby")) {
                logger.info("Current Database is a standby database with dataguardstatus value " + db.getDataguardStatus());
                ExecutionStep es = CommandUtils.getBasicExecutionStep(this.automationAction, cc, null);
                DB primaryDB = db.getDBsystemInterface().getPrimary();
                if (primaryDB.getRAC() != null) {
                    es.getCommand().addAll(this.getLogShippingCommand(es, primaryDB.getUsingDataGuardBroker(), (AbstractBaseTarget)primaryDB.getRAC()));
                    es.setHost(((RACDBInstance)primaryDB.getRAC().getDbInstances().get(0)).getHost());
                    steps.add(es);
                    logger.info("Change host to host of primary database " + ((RACDBInstance)primaryDB.getRAC().getDbInstances().get(0)).getHost().getName());
                    continue;
                }
                if (primaryDB.getSI() == null) continue;
                es.getCommand().addAll(this.getLogShippingCommand(es, primaryDB.getUsingDataGuardBroker(), (AbstractBaseTarget)primaryDB.getSI()));
                es.setHost(primaryDB.getSI().getHost());
                steps.add(es);
                continue;
            }
            if (db.getDataguardStatus() == null || !db.getDataguardStatus().toLowerCase().contains("primary") || (secondaryDB = db.getDBsystemInterface().getSecondary()) == null || secondaryDB.size() <= 0) continue;
            logger.info("Current Database is a primary database with dataguardstatus value " + db.getDataguardStatus());
            ExecutionStep es = CommandUtils.getBasicExecutionStep(this.automationAction, cc, null);
            es.getCommand().addAll(this.getLogShippingCommand(es, db.getDBsystemInterface().getUsingDataGuardBroker(), (AbstractBaseTarget)db));
            steps.add(es);
        }
        return steps;
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (a instanceof CommandAction && (a.getType().equals(DBCommandActionType.StartLogShipping.toString()) || a.getType().equals(DBCommandActionType.StopLogShipping.toString()))) {
                logger.info(" crate stop start log shipping command" + a.getType());
                return new StopStartLogShipping(a, DBCommandActionType.valueOf(a.getType()), s);
            }
            return null;
        }
    }
}

