/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.SystemModelUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class SQLStartupShutdown
extends Command {
    private static String DB_LOG = null;
    CommandAction automationAction;
    Logger logger = Logger.getLogger(SQLStartupShutdown.class.getName());

    public SQLStartupShutdown(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    @Override
    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep executionStep;
            CommandContext context = contextPopulator.populateContext(g, abstractBaseTarget, this.getHost());
            OracleHome originalHome = context.getFirstTarget(OracleHome.class);
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
            }
            if ((executionStep = this.getExecutionStep(context, originalHome)) == null) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    private ExecutionStep getExecutionStep(CommandContext context, OracleHome originalHome) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget db = context.getPrimaryTarget();
        if (DBCommandUtils.isPhysicalStandbyDatabase(db)) {
            context = DBCommandUtils.resetContextForStandbyDB(db);
            oh = context.getFirstTarget(OracleHome.class);
            db = context.getPrimaryTarget();
        }
        ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, context, null);
        ArrayList cmds = new ArrayList();
        String OracleSid = this.getOracleSIDForActiveInstance(executionStep, db);
        ArrayList<String> tempCmds = null;
        if (db instanceof SIDatabase) {
            String actionType = this.automationAction.getType();
            DB_LOG = oh.getPath() + File.separator + "cfgtoollogs" + File.separator + "opatchautodb" + File.separator;
            String sqlPlusCmd = "cd " + oh.getPath() + "; ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + OracleSid + " " + "./bin/sqlplus / as sysdba @";
            tempCmds = new ArrayList<String>();
            if (DBCommandActionType.listenerStop.name().equals(actionType)) {
                tempCmds.add(this.getListenerCmd(oh, OracleSid, false));
            } else if (DBCommandActionType.listenerStart.name().equals(actionType)) {
                tempCmds.add(this.getListenerCmd(oh, OracleSid, true));
            } else if (DBCommandActionType.SqlShutdown.name().equals(actionType)) {
                tempCmds.addAll(this.generateDBShutdownCommand(sqlPlusCmd));
            } else if (DBCommandActionType.SqlStartup.name().equals(actionType)) {
                tempCmds.addAll(this.generateDBStartupCommand(sqlPlusCmd));
            } else if (DBCommandActionType.moveDB.name().equals(actionType)) {
                tempCmds.add(this.generateDBMigrationCommand(oh, originalHome, OracleSid));
            }
        } else {
            return null;
        }
        if (tempCmds != null && !tempCmds.isEmpty()) {
            cmds.addAll(tempCmds);
        }
        for (String s : cmds) {
            executionStep.getCommand().add(new ExecutionStep.Command(s));
        }
        return executionStep;
    }

    private String generateDBMigrationCommand(OracleHome oh, OracleHome originalHome, String OracleSid) {
        String dbuaCmd = "cd " + oh.getPath() + "; " + oh.getPath() + File.separator + "bin" + File.separator + "dbua " + "-silent -sid " + OracleSid + " -oraclehome " + originalHome.getPath();
        return dbuaCmd;
    }

    private String getListenerCmd(OracleHome oh, String OracleSid, boolean startUp) {
        String ops = "stop";
        if (startUp) {
            ops = "start";
        }
        String listenerStopCmd = "cd " + oh.getPath() + "; ORACLE_HOME=" + oh.getPath() + " ORACLE_SID=" + OracleSid + " " + oh.getPath() + File.separator + "bin" + File.separator + "lsnrctl " + ops;
        return listenerStopCmd;
    }

    private List<String> generateDBShutdownCommand(String sqlPlusCmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        String dataPatchfileForSetClusterTrue = DB_LOG + "sqlshutdown.sql";
        cmds.add("echo 'SET HEADING OFF' > " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'SET SERVEROUTPUT OFF' >> " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'SPOOL " + DB_LOG + File.separator + "sqlshutdownlog.txt' >> " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'shutdown immediate' > " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'SPOOL OFF' >> " + dataPatchfileForSetClusterTrue);
        cmds.add("echo 'quit' >> " + dataPatchfileForSetClusterTrue);
        cmds.add(sqlPlusCmd + dataPatchfileForSetClusterTrue);
        cmds.add("rm -rf " + dataPatchfileForSetClusterTrue);
        return cmds;
    }

    private List<String> generateDBStartupCommand(String sqlPlusCmd) {
        ArrayList<String> cmds = new ArrayList<String>();
        String dataPatchfileForStartupUpgrade = DB_LOG + "dataPatchfileForStartupUpgrade.sql";
        cmds.add("echo 'SET HEADING OFF' > " + dataPatchfileForStartupUpgrade);
        cmds.add("echo 'SET SERVEROUTPUT OFF' >> " + dataPatchfileForStartupUpgrade);
        cmds.add("echo 'SPOOL " + DB_LOG + File.separator + "sqlstartuplog.txt' >> " + dataPatchfileForStartupUpgrade);
        cmds.add("echo 'startup ' > " + dataPatchfileForStartupUpgrade);
        cmds.add("echo 'SPOOL OFF' >> " + dataPatchfileForStartupUpgrade);
        cmds.add("echo 'quit' >> " + dataPatchfileForStartupUpgrade);
        cmds.add(sqlPlusCmd + dataPatchfileForStartupUpgrade);
        cmds.add("rm -rf " + dataPatchfileForStartupUpgrade);
        return cmds;
    }

    private String getOracleSIDForActiveInstance(ExecutionStep executionStep, AbstractBaseTarget primaryTarget) {
        if (primaryTarget instanceof SIDatabase) {
            SIDatabase siDB = (SIDatabase)primaryTarget;
            return siDB.getInstanceName();
        }
        throw new PatchPlanException("Can not get OracleSID from " + primaryTarget.getClass().getName());
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class<? extends AbstractBaseTarget> type = SystemModelUtils.getClassForType(this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder<SQLStartupShutdown> {
        @Override
        public SQLStartupShutdown getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction && (a.getType().equals(DBCommandActionType.SqlShutdown.toString()) || a.getType().equals(DBCommandActionType.SqlStartup.toString()) || a.getType().equals(DBCommandActionType.listenerStop.toString()) || a.getType().equals(DBCommandActionType.listenerStart.toString()) || a.getType().equals(DBCommandActionType.moveDB.toString())))) {
                return null;
            }
            return new SQLStartupShutdown((CommandAction)a);
        }
    }
}

