/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.cookies.CRSMakeCloneHome;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class RelinkBinary
extends SimpleShellCommand {
    public RelinkBinary(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        CRSMakeCloneHome makeCloneHome = (CRSMakeCloneHome)PatchPlanner.getInstance().getMakeCloneHome();
        List<OracleHome> clones = makeCloneHome.getHomeClone(oh);
        String scriptFile = HelperUtility.detectOraBaseHome((String)oh.getPath()) + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB + "relinkbinary";
        int count = 1;
        String tmpScriptFilePath = null;
        for (OracleHome clone : clones) {
            tmpScriptFilePath = scriptFile + count + ".sh";
            cmds.add("echo '#!/bin/sh' > " + tmpScriptFilePath);
            cmds.add("echo ORIG_PROTO=`" + oh.getPath() + "/bin/skgxpinfo` >> " + tmpScriptFilePath);
            String cmd = "if [ $ORIG_PROTO = 'rds' ]; then cd " + clone.getPath() + "/rdbms/lib; " + "ORACLE_HOME=" + clone.getPath() + " make -f ins_rdbms.mk ipc_rds ioracle; fi";
            cmds.add("echo '" + cmd + "' >> " + tmpScriptFilePath);
            cmds.add("echo 'exit 0;' >> " + tmpScriptFilePath);
            cmds.add("chmod +x " + tmpScriptFilePath);
            cmds.add(tmpScriptFilePath);
            cmds.add("rm -rf " + tmpScriptFilePath);
            ++count;
        }
        return cmds;
    }

    public static class Builder
    implements CommandBuilder<RelinkBinary> {
        @Override
        public RelinkBinary getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.RelinkBinary.toString())) {
                return null;
            }
            return new RelinkBinary(a);
        }
    }
}

