/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import dbmodel.db_crs.HAS;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class CopyDBHome
extends SimpleShellCommand {
    public CopyDBHome(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        final ArrayList<String> cmds = new ArrayList<String>();
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<OracleHome> clones = PatchPlanner.getInstance().getMakeCloneHome().getHomeClone(oh);
        AbstractBaseTarget root = PatchPlanner.getInstance().getConfigGraph().getRootVertex();
        boolean isSidbPatching = !(root instanceof CRSCluster) && !(root instanceof HAS);
        for (OracleHome clone : clones) {
            String clonePath = clone.getPath();
            while (clonePath.lastIndexOf("/") == clonePath.length() - 1) {
                clonePath = clonePath.substring(0, clonePath.length() - 1);
            }
            String isBackportEnabledToExcludeScript = PatchPlanner.getInstance().getOPlanEnv().getProperty("EMBackportToExcludeSpecialScripts");
            if (null != isBackportEnabledToExcludeScript && isBackportEnabledToExcludeScript.equalsIgnoreCase("ENABLE")) {
                cmds.add("mkdir -p " + clonePath.substring(0, clonePath.lastIndexOf("/")));
            } else {
                this.changeCloneOwnerAndGroup(cmds, clonePath.substring(0, clonePath.lastIndexOf("/")), oh.getPath());
            }
            if (this.automationAction.getType().equals(DBCommandActionType.RSyncDBHome.toString())) {
                cmds.add("rsync -a " + oh.getPath() + File.separator + " " + clone.getPath());
            } else {
                cmds.add("cp -pR " + oh.getPath() + " " + clone.getPath());
            }
            if (isSidbPatching) {
                final File cloneDir = new File(clone.getPath() + File.separator + "network" + File.separator + "admin" + File.separator);
                File origDir = new File(oh.getPath() + File.separator + "network" + File.separator + "admin" + File.separator);
                if (origDir.exists()) {
                    origDir.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String filename) {
                            if (filename.endsWith(".ora")) {
                                cmds.add("rm -f " + cloneDir.getAbsolutePath() + File.separator + filename);
                            }
                            return true;
                        }
                    });
                }
            } else {
                cmds.add("rm -f " + clone.getPath() + ProductDriverConstants.OPATCH_AUTO_CRS_SESSION_INIT + this.getHost().getHostName());
            }
            cmds.add("rm " + clone.getPath() + "/root.sh");
            cmds.add("rm -rf " + clone.getPath() + DBCommonPatchingConstants.OPATCH_AUTO_DBTMP + "*" + " || true");
            cmds.add("rm -rf " + clone.getPath() + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + "*" + " || true");
        }
        return cmds;
    }

    private void changeCloneOwnerAndGroup(List<String> cmds, String clonePath, String ohPath) {
        String scriptFile = ohPath + DBCommonPatchingConstants.PERL_RELATIVE_PATH + ohPath + DBCommonPatchingConstants.OPATCH_AUTO_BIN_DIR + "chgchown.pl " + ohPath + " " + clonePath;
        cmds.add(scriptFile);
    }

    public static class Builder
    implements CommandBuilder<CopyDBHome> {
        @Override
        public CopyDBHome getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.CopyDBHome.toString()) && !a.getType().equals(DBCommandActionType.RSyncDBHome.toString())) {
                return null;
            }
            CopyDBHome ch = new CopyDBHome(a);
            return ch;
        }
    }
}

