/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands.OracleHomeLifecycle;
import com.oracle.glcm.patch.auto.db.product.engine.CRSContextPopulator;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.Host;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.CRSCluster;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.LifecycleAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class AllRACOracleHomeLifeCycle
extends Command {
    protected String type = DBCommandActionType.start.toString();
    protected Strategy s = Strategy.MANUAL;
    List<String> processed = new ArrayList<String>();

    public AllRACOracleHomeLifeCycle(ActionType automationAction, String type, Strategy s) {
        super(automationAction);
        this.type = type;
        this.s = s;
    }

    private static String getUUID(OracleHome oh) {
        boolean clone = false;
        if (oh.getOriginalOracleHome() != null) {
            oh = oh.getOriginalOracleHome();
            clone = true;
        }
        String str = oh.getUniqueId().replace(':', '_');
        if (clone) {
            str = str + "_clone";
        }
        return str;
    }

    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getTarget(OracleHome.class);
        Host host = context.getTarget(Host.class);
        ArrayList<String> cmds = new ArrayList<String>();
        Logger.getLogger(OracleHomeLifecycle.class.getName()).info("type: " + this.type);
        String uuid = AllRACOracleHomeLifeCycle.getUUID(oh);
        File statefile = new File(oh.getPath(), uuid + ".stat");
        if (this.type.equalsIgnoreCase(DBCommandActionType.stop.toString())) {
            cmds.add("rm -f " + statefile.getAbsolutePath());
        }
        String cmd = "ORACLE_HOME=" + oh.getPath() + " " + oh.getPath() + "/bin/srvctl " + this.type + " home -o " + oh.getPath();
        if (PatchPlanner.getInstance().getConfigGraph().getRootVertex() instanceof CRSCluster) {
            cmd = cmd + " -n " + host.getHostName();
        }
        if (this.type.equalsIgnoreCase(DBCommandActionType.stop.toString())) {
            cmd = cmd + " -f";
            if (oh.getHomeType().equals("rac")) {
                String version = DBCommandUtils.getRACDBVersionForCurrentHome(oh);
                if (version != null) {
                    cmd = version.startsWith("11") ? cmd + " -t TRANSACTIONAL" : cmd + " -stopoption TRANSACTIONAL";
                } else {
                    Logger.getLogger(AllRACOracleHomeLifeCycle.class.getName()).info("Unable to get the DB version, so not performing stop DB home in transactional mode");
                }
            }
        }
        cmd = cmd + " -s " + statefile.getAbsolutePath();
        cmds.add(cmd);
        return cmds;
    }

    public ExecutionStep getExecutionStep(CommandContext context) {
        ExecutionStep executionStep = CommandUtils.getBasicExecutionStep(this.automationAction, context, null);
        for (String cmd : this.getShellCommands(context)) {
            executionStep.getCommand().add(new ExecutionStep.Command(cmd));
        }
        return executionStep;
    }

    @Override
    public List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        List<? extends AbstractBaseTarget> ohs = actsOnlyOnTargets;
        for (OracleHome oracleHome : ohs) {
            CommandContext context = contextPopulator.populateContext(g, (AbstractBaseTarget)oracleHome, this.getHost());
            if (!CommandUtils.shouldShutdownRACInstance(this.getPatchingPhase(), oracleHome.getPath())) continue;
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
                OracleHome oh = context.getFirstTarget(OracleHome.class);
                if (oh.getOriginalOracleHome() != null && oh.getOriginalOracleHome().getPath().equals(oh.getPath())) continue;
            }
            ExecutionStep step = this.getExecutionStep(context);
            if (this.s.equals((Object)Strategy.DCLI)) {
                step.setHost(g.getLocalHost());
            }
            steps.add(step);
        }
        return steps;
    }

    @Override
    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        return g.getTargets(OracleHome.class, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder<AllRACOracleHomeLifeCycle> {
        @Override
        public AllRACOracleHomeLifeCycle getCommand(ActionType a, Strategy s) {
            if (!(a instanceof LifecycleAction) || a.getActsOn() == null || !a.getActsOn().equals("AllOracleHome")) {
                return null;
            }
            AllRACOracleHomeLifeCycle com = new AllRACOracleHomeLifeCycle(a, a.getType(), s);
            return com;
        }
    }
}

