/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.integration.controller.PatchZipConstructor;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.SDBProductSupport;
import java.io.File;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;

public class PatchZipCreator {
    private static final Logger _log = Logger.getLogger(SDBProductSupport.class.getName());

    public void createzipOnLocal(String patchLocation, CredentialManager credentialManager) throws OPatchAutoException {
        String homeForZipCreation = OPatchAutoHelper.getOPatchAutoHome();
        PatchZipConstructor patchZipConstructor = new PatchZipConstructor();
        _log.info("Home For Zip Creation : " + homeForZipCreation);
        byte[] b = null;
        String ohOwner = OUIDriver.checkFileOwner((File)new File(homeForZipCreation, "oraInst.loc"));
        if (credentialManager != null) {
            Credential credential;
            String currentHostName = OPatchAutoHelper.getOPatchAutoHost();
            if (currentHostName != null && currentHostName.indexOf(".") != -1) {
                currentHostName = currentHostName.substring(0, currentHostName.indexOf("."));
            }
            if ((credential = credentialManager.getCredential(currentHostName)) != null) {
                b = OPatchAutoHelper.toBytes((char[])credential.getPassword());
            }
        }
        patchZipConstructor.createZip(patchLocation, homeForZipCreation, ohOwner, b);
    }
}

