/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.TopologyBuilder;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import com.oracle.glcm.patch.auto.topology.Host;
import com.oracle.glcm.patch.auto.topology.Topology;
import com.oracle.glcm.patch.auto.topology.TopologyImpl;
import dbmodel.SystemInstance;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTopologyBuilder
implements TopologyBuilder {
    Logger logger = Logger.getLogger(AbstractTopologyBuilder.class.getName());
    protected Topology topology = null;
    protected final OPatchAutoOptions options;
    protected final OPatchAutoCommand command;
    protected boolean isDefaultProductTypeRequired = false;
    protected CredentialManager credentialManager;
    protected HashMap<String, List<Home>> _linkedHomeList = new HashMap();
    private Map<String, String> libPathMap = new HashMap<String, String>();

    public AbstractTopologyBuilder(OPatchAutoCommand command, OPatchAutoOptions options) {
        this.command = command;
        this.options = options;
    }

    @Override
    public void buildTopology(CredentialManager credentialManager) throws OPatchAutoException {
        this.logger.log(Level.INFO, "Topology creation started...");
        this.credentialManager = credentialManager;
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        if (configGraph == null) {
            this.createSystemInstance();
            configGraph = PatchPlanner.getInstance().getConfigGraph();
        }
        SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
        OPatchAutoOption deployOnlyOption = this.options.getOption(DBProductParameterConstants.DEPLOY_ONLY.getValue());
        Boolean isDeployOnly = Boolean.valueOf(deployOnlyOption.getValue());
        List<Object> failedValidations = new ArrayList();
        if (!(isDeployOnly.booleanValue() || this.command.isReport() || this.command.isResumed())) {
            this.logger.log(Level.INFO, "Running Validations in build-topology phase...");
            failedValidations = this.validate(systemInstance, configGraph);
        }
        if (null != failedValidations && !failedValidations.isEmpty()) {
            Object arguments = new Object();
            int errorCode = ((ValidationResult)failedValidations.get(0)).getFailureReason().getErrorCode();
            if (null != ((ValidationResult)failedValidations.get(0)).getPayload()) {
                arguments = ((ValidationResult)failedValidations.get(0)).getPayload();
            }
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(errorCode), (Object[])new Object[]{arguments}), new Object[0]);
        }
        if (!(DBPatchingHelper.isStaticConfiguration(this.options) || DBPatchingHelper.isOOPSwitchPatchingSession(this.options) && this.command.isApply() || this.command.isResumed())) {
            try {
                systemInstance.writeFile(this.createSystemInstanceXML());
            }
            catch (FileNotFoundException e1) {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72035), (Object[])new Object[]{""}), new Object[0]);
            }
        }
    }

    @Override
    public void setDefaultProductTypeRequired(boolean isDefaultProductTypeRequired) {
        this.isDefaultProductTypeRequired = isDefaultProductTypeRequired;
    }

    protected abstract File createSystemInstanceXML() throws OPatchAutoException;

    public Topology getTopology(List<Host> hosts) {
        this.logger.log(Level.INFO, "Creating topology from system instance...");
        TopologyImpl topology = new TopologyImpl();
        if (hosts != null) {
            for (Host host : hosts) {
                topology.addHost(host);
            }
        }
        return topology;
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public Map<String, String> getLibPathMap() {
        return this.libPathMap;
    }

    protected File readSystemInstanceXML() throws OPatchAutoException {
        String path = this.getSystemInstanceFilePath();
        String sysInstanceConfigXML = path + File.separator + this.getSystemInstanceFileName();
        return new File(sysInstanceConfigXML);
    }

    protected String getSystemInstanceFilePath() throws OPatchAutoException {
        String oracleHomePath = OPatchAutoHelper.getOPatchAutoHome();
        String patchId = null;
        OOPSessionInfo oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo();
        if (oopSessionInfo != null) {
            patchId = oopSessionInfo.getPatchInfo().getPatchDirName();
        } else if (this.command.isReport()) {
            patchId = this.options.getOption("session").getValue();
        } else {
            String patchInformation = this.options.getOption("id").getValue();
            if (StringUtil.isNullOrEmpty((String)patchInformation)) {
                patchInformation = this.options.getOption("patch.location").getValue();
                if (StringUtil.isNullOrEmpty((String)patchInformation, (boolean)true)) {
                    patchInformation = this.options.getOption("patch.base.directory").getValue();
                }
                patchId = new File(patchInformation).getName();
            } else {
                String[] patchIDList = patchInformation.split(",");
                patchId = patchIDList[0];
            }
        }
        String path = SessionData.getConfigDir() + File.separator + patchId;
        return path;
    }

    protected abstract String getSystemInstanceFileName() throws OPatchAutoException;

    protected void addToLinkedHomeList(Home home) {
        if (this._linkedHomeList.containsKey(home.getLocation())) {
            List<Home> sharedHomeList = this._linkedHomeList.get(home.getLocation());
            if (!sharedHomeList.contains(home)) {
                sharedHomeList.add(home);
            }
        } else {
            ArrayList<Home> sharedHomeList = new ArrayList<Home>();
            sharedHomeList.add(home);
            this._linkedHomeList.put(home.getLocation(), sharedHomeList);
        }
    }

    protected void fillSharedHomeInformation(List<Host> hostList) {
        for (Host host : hostList) {
            Set homeList = host.getHomes();
            for (Home home : homeList) {
                List<Home> sharedHomeList;
                ArrayList<Home> copySharedHomeList;
                if (!this._linkedHomeList.containsKey(home.getLocation()) || !(copySharedHomeList = new ArrayList<Home>(sharedHomeList = this._linkedHomeList.get(home.getLocation()))).contains(home)) continue;
                copySharedHomeList.remove(home);
                ((HomeImpl)home).setSharedHomeList(copySharedHomeList);
                this.logger.log(Level.INFO, "Adding shared home list to" + home + ", list is " + copySharedHomeList);
            }
        }
    }

    protected void putLibPath(String hostName, String homePath) {
        this.libPathMap.put(hostName, homePath);
    }
}

