/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.shard.ShardDBProductTypes;
import com.oracle.glcm.patch.auto.product.ProductType;
import com.oracle.glcm.patch.auto.product.SupportType;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Instance;
import java.io.Serializable;
import java.util.Set;

public class DatabaseProductType
implements ProductType,
Serializable {
    private static final long serialVersionUID = 1L;

    public String getType() {
        return ShardDBProductTypes.PRODUCT_TYPE_DATABASE.getValue();
    }

    public SupportType getSupportType() {
        return SupportType.home;
    }

    public boolean isSupportedHome(Home home) throws OPatchAutoException {
        boolean isSupported = false;
        Set productTypesList = home.getProductTypes();
        for (ProductType type : productTypesList) {
            if (!type.equals(this.getType())) continue;
            isSupported = true;
            break;
        }
        return isSupported;
    }

    public boolean isSupportedInstance(Instance instance) throws OPatchAutoException {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseProductType)) {
            return false;
        }
        DatabaseProductType that = (DatabaseProductType)o;
        if (SupportType.home != that.getSupportType()) {
            return false;
        }
        return this.getType().equals(that.getType());
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getSupportType().hashCode();
        return result;
    }

    public String toString() {
        return this.getType() + " [" + this.getSupportType() + "]";
    }
}

