/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.plan;

import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementContainer;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementContainerImpl;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementSetCreator;
import com.oracle.glcm.patch.auto.plan.PatchPlanIncrementType;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Host;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class DBPatchPlanIncrementSetCreatorImpl
implements PatchPlanIncrementSetCreator {
    private PatchPlanIncrementType _incrementType;

    private DBPatchPlanIncrementSetCreatorImpl(PatchPlanIncrementType incrementType) {
        this._incrementType = incrementType;
    }

    public Set<PatchPlanIncrementContainer> getContainers(Set<PatchTarget> patchTargets) {
        LinkedHashSet<PatchPlanIncrementContainer> containers = new LinkedHashSet<PatchPlanIncrementContainer>();
        if (this._incrementType == DBPatchPlanIncrementType.host_nonrolling) {
            String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
            boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
            if (isTwelveVersion && this.isGINeedsToBePatched(patchTargets)) {
                LinkedHashSet<PatchTarget> firstHostPatchTargets = new LinkedHashSet<PatchTarget>();
                LinkedHashSet<PatchTarget> lastHostPatchTargets = new LinkedHashSet<PatchTarget>();
                LinkedHashSet<PatchTarget> otherHostPatchTargets = new LinkedHashSet<PatchTarget>();
                Host firstHost = null;
                Host lastHost = null;
                if (patchTargets != null && patchTargets.size() > 0) {
                    Iterator<PatchTarget> patchTargetList = patchTargets.iterator();
                    while (patchTargetList.hasNext()) {
                        PatchTarget target = patchTargetList.next();
                        if (firstHost == null) {
                            firstHost = target.getHost();
                            continue;
                        }
                        if (patchTargetList.hasNext()) continue;
                        lastHost = target.getHost();
                    }
                }
                for (PatchTarget patchTarget : patchTargets) {
                    Host host = patchTarget.getHost();
                    if (host.equals(firstHost)) {
                        firstHostPatchTargets.add(patchTarget);
                        continue;
                    }
                    if (host.equals(lastHost)) {
                        lastHostPatchTargets.add(patchTarget);
                        continue;
                    }
                    otherHostPatchTargets.add(patchTarget);
                }
                if (firstHostPatchTargets.size() > 0) {
                    containers.add((PatchPlanIncrementContainer)new PatchPlanIncrementContainerImpl(firstHostPatchTargets));
                }
                if (otherHostPatchTargets.size() > 0) {
                    containers.add((PatchPlanIncrementContainer)new PatchPlanIncrementContainerImpl(otherHostPatchTargets));
                }
                if (lastHostPatchTargets.size() > 0) {
                    containers.add((PatchPlanIncrementContainer)new PatchPlanIncrementContainerImpl(lastHostPatchTargets));
                }
            } else {
                LinkedHashSet<PatchTarget> otherHostPatchTargets = new LinkedHashSet<PatchTarget>();
                for (PatchTarget patchTarget : patchTargets) {
                    otherHostPatchTargets.add(patchTarget);
                }
                if (otherHostPatchTargets.size() > 0) {
                    containers.add((PatchPlanIncrementContainer)new PatchPlanIncrementContainerImpl(otherHostPatchTargets));
                }
            }
        }
        return containers;
    }

    private boolean isGINeedsToBePatched(Set<PatchTarget> patchTargets) {
        boolean isGITarget = false;
        for (PatchTarget target : patchTargets) {
            if (!target.getType().equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue())) continue;
            isGITarget = true;
            break;
        }
        return isGITarget;
    }

    public static enum DBPatchPlanIncrementType implements PatchPlanIncrementType
    {
        host_nonrolling;


        public PatchPlanIncrementSetCreator getPatchPlanIncrementSetCreator() {
            return new DBPatchPlanIncrementSetCreatorImpl(this);
        }
    }
}

