/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandUtils;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.SystemInstance;
import dbmodel.db_crs.SIDatabase;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;

public class SIDBStartupAction
extends DBShutDownStartupAction {
    Logger logger = Logger.getLogger(SIDBStartupAction.class.getName());
    private String strSID = "";

    public SIDBStartupAction() {
        super(new Goal[]{StartupPhase.Goal.startup});
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isRequired = super.isActionRequired(patchTarget);
        if (!isRequired) {
            return isRequired;
        }
        boolean oopPatchingSession = DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        try {
            Boolean isSidbOnly = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue());
            Boolean isSidb = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).getValue());
            this.strSID = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SID.getValue()).getValue();
            if (isSidbOnly.booleanValue()) {
                SystemInstance systemInstance = PatchPlanner.getInstance().getSystemInstance();
                SIDatabase siDatabase = (SIDatabase)systemInstance.getTargetsOfType(SIDatabase.class).get(0);
                String sidbDbUp = siDatabase.getShardProperty().getIsDatabaseUp();
                isRequired = "Y".equalsIgnoreCase(sidbDbUp);
                return isRequired;
            }
            String home = patchTarget.getHome().getLocation();
            if (!oopPatchingSession && isSidb.booleanValue()) {
                if (!CommandUtils.isInstanceShutdownPatch(home)) {
                    isRequired = false;
                } else {
                    boolean bl = isRequired = !SessionData.getInstance().getIsSIDBDown() || SessionData.getInstance().getListenerDown();
                }
            }
            if (!isSidb.booleanValue()) {
                isRequired = ClusterInformationLoader.getInstance().isStackRunning();
            }
        }
        catch (Exception e) {
            throw new PatchActionException("Exception : " + e.getMessage(), new Object[0]);
        }
        return isRequired;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        String loc;
        String owner;
        String cmd;
        GISystemCall.ExecReturn ret;
        List<ExecutionStep> generatedSteps = super.generateSteps(patchTarget);
        if (SessionData.getInstance().getListenerDown() && !(ret = GISystemCall.process(cmd = this.getListenerCmd(patchTarget, patchTarget.getHome().getLocation(), this.strSID, true), owner = FileUtility.checkFileOwner((File)new File(loc = patchTarget.getHome(true).getLocation(), "oraInst.loc")), this.getPassword(patchTarget))).isOK()) {
            this._logger.info("Listener could not be started....");
        }
        List<ExecutionStep> steps = this.getStartOracleHomeCommandExecutionSteps(this.configGraph, patchTarget, "sidb", "OracleHome");
        if (!DBPatchingHelper.isNoRestartEnable(this.getPatchSession().getOptions())) {
            if (!SessionData.getInstance().getIsSIDBDown()) {
                generatedSteps.addAll(steps);
            }
        } else {
            Reporting.report((String)this.getLocalizedString("StartAction.norestart.database.warning", patchTarget.getHome().getLocation()));
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }
}

