/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBShutDownStartupAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SIDBFinalizeStartAction
extends DBShutDownStartupAction {
    public SIDBFinalizeStartAction() {
        super(new Goal[]{StartupPhase.Goal.finalize});
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        List<ExecutionStep> generatedSteps = super.generateSteps(patchTarget);
        List<ExecutionStep> steps = null;
        String primaryPatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isNoRestartEnable = DBPatchingHelper.isNoRestartEnable(this.getPatchSession().getOptions());
        if (primaryPatchVersion.startsWith("12.1.0.1") && !isNoRestartEnable) {
            steps = this.getStartPDBStateCommandExecutionSteps(this.configGraph, patchTarget, "SIDatabase");
            generatedSteps.addAll(steps);
        }
        if (isNoRestartEnable) {
            this._logger.info("OPatchauto is running in norestart mode. PDB instances will not be checked for database on the current node.");
        }
        if (DBPatchingUtil.isDBVersionEleven(primaryPatchVersion)) {
            steps = this.getStopStartDBConsoleCommandExecutionSteps(this.configGraph, patchTarget, "SIDatabase", DBShutDownStartupAction.StopStartOperation.STARTUP);
            generatedSteps.addAll(steps);
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }
}

