/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class RemoteGIStopAction
extends DBCommonPatchAction {
    public RemoteGIStopAction() {
        super(new Goal[]{ShutdownPhase.Goal.prepare_shutdown, OfflinePhase.Goal.finalize});
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        isActionRequired = this.isActionRequiredForGoal();
        if (!isActionRequired) {
            return isActionRequired;
        }
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        try {
            ClusterInformationLoader.ClusterStatus status;
            boolean bl = isActionRequired = isTwelveVersion && DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions()) && patchTarget.isRemote();
            if (isActionRequired && (status = ClusterInformationLoader.getInstance().isStackRunningOnRemote(patchTarget.getHost().getHost())) != ClusterInformationLoader.ClusterStatus.CRS_RUNNING) {
                isActionRequired = false;
            }
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
        return isActionRequired;
    }

    private boolean isActionRequiredForGoal() {
        boolean isActionRequired = true;
        boolean oopPatchingSession = DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        if (oopPatchingSession) {
            boolean oopPreparePatchingSession = DBPatchingHelper.isOOPPreparePatchingSession(this.getPatchSession().getOptions());
            if (oopPreparePatchingSession || this.getCurrentGoal().equals(ShutdownPhase.Goal.prepare_shutdown)) {
                isActionRequired = false;
            }
        } else if (this.getCurrentGoal().equals(OfflinePhase.Goal.finalize)) {
            isActionRequired = false;
        }
        return isActionRequired;
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(OfflinePhase.Goal.finalize)) {
            return 120;
        }
        return super.getOrderingWeight(goal);
    }

    @Override
    protected PatchActionResult executeSteps(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        return super.executeSteps(executionSteps, patchTarget);
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<ExecutionStep> generatedSteps = this.getStopCrsCommandExecutionSteps(configGraph, patchTarget);
        return generatedSteps;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        return targetList;
    }

    private List<ExecutionStep> getStopCrsCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.StopCRS.toString());
        argList.put(CommandDetailsGenerator.ActionTypeParams.RUN_AS, DBCommandParameters.GLOBAL_ROOT_USER.getValue());
        argList.put(CommandDetailsGenerator.ActionTypeParams.SERVICE_STATUS, ServiceStatus.DOWN);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.crs");
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, "crs");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Stop-CRS-Title");
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, "Stop-CRS-Message");
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getpatchingPhase();
        Command stopHasCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, stopHasCommand);
        return steps;
    }

    private PatchingPhase getpatchingPhase() {
        PatchingPhase phase = null;
        phase = this.getPatchSession().isRollback() ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.ROLLBACK, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.LIMITED);
        return phase;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("RemoteGIStopAction.start.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("RemoteGIStopAction.failure.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("RemoteGIStopAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("RemoteGIStopAction.success.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }
}

