/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.crs;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.TrackOOPSessions;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.OnlineAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfo;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OnlinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class RACOnlineAction
extends OnlineAction {
    public RACOnlineAction() {
        super((Goal)OnlinePhase.Goal.product_patching);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        try {
            Boolean isSidb = Boolean.parseBoolean(this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).getValue());
            if (isSidb.booleanValue()) {
                return false;
            }
        }
        catch (Exception e) {
            throw new PatchActionException("Exception : " + e.getMessage(), new Object[0]);
        }
        return super.isActionRequired(patchTarget);
    }

    @Override
    protected boolean isPatchApplicabilityCheckRequired(PatchTarget patchTarget) {
        return !patchTarget.getHome().isSharedHome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult;
        block51: {
            OPatchAutoOptions options;
            ConfigGraph configGraph;
            ArrayList<ExecutionStep> postDatapatchSteps;
            ArrayList<ExecutionStep> datapatchSteps;
            ArrayList<ExecutionStep> preDatapatchSteps;
            block50: {
                patchActionResult = new PatchActionResult();
                preDatapatchSteps = new ArrayList<ExecutionStep>();
                datapatchSteps = new ArrayList<ExecutionStep>();
                postDatapatchSteps = new ArrayList<ExecutionStep>();
                configGraph = PatchPlanner.getInstance().getConfigGraph();
                options = this.getPatchSession().getOptions();
                boolean switchSession = false;
                try {
                    switchSession = options.getOption(DBProductParameterConstants.SWITCH_CLONE_KEY.getValue()).isSwitchEnabled();
                }
                catch (OPatchAutoException e) {
                    switchSession = false;
                }
                SessionData.getInstance().setOOPApplySwitch(switchSession);
                this._logger.info("OOP Apply Switch Patching session: " + switchSession);
                try {
                    if (!DBPatchingHelper.isOOPPatchingSession(options)) break block50;
                    if (!patchTarget.getHome().isSharedHome()) {
                        String home = patchTarget.getHome(true).getLocation();
                        String switchHome = OOPSessionInfoHandler.getInstance().getCloneHomePath(home);
                        OOPSessionInfo oopSessionInfo = OOPSessionInfoHandler.getInstance().getOOPSessionInfo();
                        OracleHomePatchLevel ohpl = oopSessionInfo.getIncomingPatchesOnNodes();
                        List<Object> patchInfos = new ArrayList();
                        Map<String, List<OPatchPatchInfo>> oracleHomePatchLevel = ohpl.getOracleHomePatchLevel();
                        if (DBPatchingHelper.isOOPApplySwitchCloneSession(options) || DBPatchingHelper.isSingleOOPPatchingSession(options)) {
                            if (ohpl == null || ohpl.getOracleHomePatchLevel().get(switchHome) == null || ohpl.getOracleHomePatchLevel().get(switchHome).size() == 0) {
                                this._logger.info("Incoming patch data not available from oop apply session cookie.");
                            } else {
                                patchInfos = oracleHomePatchLevel.get(switchHome);
                            }
                        }
                        if (DBPatchingHelper.isOOPSwitchbackSession(options)) {
                            if (ohpl == null || ohpl.getOracleHomePatchLevel().get(home) == null || ohpl.getOracleHomePatchLevel().get(home).size() == 0) {
                                this._logger.info("Incoming patch data not available from oop switchback session cookie.");
                            } else {
                                patchInfos = oracleHomePatchLevel.get(home);
                            }
                        }
                        if (patchInfos == null || patchInfos.size() <= 0) break block50;
                        for (OPatchPatchInfo info : patchInfos) {
                            if (!info.isSQLPatch()) continue;
                            SessionData.getInstance().setOOPSQLPatch(true);
                            this._logger.info("OOP SQL Patching session: true");
                            break block50;
                        }
                        break block50;
                    }
                    SessionData.getInstance().setOOPSQLPatch(true);
                    this._logger.info("OOP SQL Patching session for shared home: true");
                }
                catch (Exception e) {
                    SessionData.getInstance().setOOPSQLPatch(true);
                    this._logger.info("Unable to identify patches of previous session.");
                }
            }
            try {
                String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
                boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
                List<ExecutionStep> steps = null;
                if (isTwelveVersion) {
                    steps = this.getStartRedoApplyCommandExecutionSteps(configGraph, patchTarget, null, "RACDatabase");
                    preDatapatchSteps.addAll(steps);
                }
                boolean actsOnClone = patchTarget.isUsingHomeClone();
                if (isTwelveVersion) {
                    boolean isSQLPatchInUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
                    if (isSQLPatchInUpgradeMode) {
                        steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchDisableCluster.toString(), "RACDatabase", "SQL-Disable-Cluster-Step-Title", actsOnClone);
                        preDatapatchSteps.addAll(steps);
                        if (this.isSQLUpgrdeModeCommandRequired(steps)) {
                            steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.stopOnAllHost.toString(), "rac", ServiceStatus.DOWN, "OracleHome", "Stop-Home-Title", "Stop-Home-Message");
                            preDatapatchSteps.addAll(steps);
                        }
                        steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchStartupUpgradeMode.toString(), "RACDatabase", "SQL-Startup-Upgrade-Mode-Step-Title", actsOnClone);
                        preDatapatchSteps.addAll(steps);
                        if (this.isSQLUpgrdeModeCommandRequired(steps)) {
                            steps = this.getUpgradePDBStateCommandExecutionSteps(configGraph, patchTarget, "RACDBInstance");
                            preDatapatchSteps.addAll(steps);
                        }
                    }
                    if (this.getPatchSession().isRollback()) {
                        if (DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
                            steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchSwitchback.toString(), "RACDatabase", actsOnClone);
                            preDatapatchSteps.addAll(steps);
                            preDatapatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchSwitchback.toString(), actsOnClone));
                        }
                        steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchRollback.toString(), "RACDatabase", actsOnClone);
                        if (DBPatchingHelper.isOOPPatchingSession(options)) {
                            if (SessionData.getInstance().isOOPSQLPatch()) {
                                datapatchSteps.addAll(steps);
                                datapatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchRollback.toString(), actsOnClone));
                                this._logger.info("All datapatch steps will be run for OOP.");
                            } else {
                                this._logger.info("Datapatch steps will be skipped for OOP since there are no incoming SQL patches.");
                            }
                        } else {
                            datapatchSteps.addAll(DBPatchingHelper.filterLastNodeSteps(patchTarget, steps, this.getPatchSession().isRollback()));
                            datapatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchRollback.toString(), actsOnClone));
                        }
                    } else {
                        steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchApply.toString(), "RACDatabase", actsOnClone);
                        if (DBPatchingHelper.isOOPPatchingSession(options)) {
                            if (SessionData.getInstance().isOOPSQLPatch()) {
                                this._logger.info("All datapatch steps will be run for OOP.");
                                datapatchSteps.addAll(steps);
                                datapatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchApply.toString(), actsOnClone));
                            } else {
                                this._logger.info("Datapatch steps will be skipped for OOP since there are no incoming SQL patches.");
                            }
                        } else {
                            datapatchSteps.addAll(DBPatchingHelper.filterLastNodeSteps(patchTarget, steps, this.getPatchSession().isRollback()));
                            datapatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchApply.toString(), actsOnClone));
                        }
                    }
                    if (datapatchSteps.isEmpty()) {
                        this.sqlActionNotRequired = true;
                        String msg = "No sqlpatch operations are required on the local node for this home";
                        this._logger.info(msg + " : " + patchTarget.getHome(true).getLocation());
                    } else {
                        this._logger.info("datapatch will be run on " + datapatchSteps.size() + " instances.");
                    }
                    if (isSQLPatchInUpgradeMode) {
                        steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchEnableCluster.toString(), "RACDatabase", "SQL-Startup-Enable-Cluster-Step-Title", actsOnClone);
                        postDatapatchSteps.addAll(steps);
                        if (this.isSQLUpgrdeModeCommandRequired(steps)) {
                            steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.startOnAllHost.toString(), "rac", ServiceStatus.UP, "OracleHome", "Start-Home-Title", "Start-Home-Message");
                            postDatapatchSteps.addAll(steps);
                            steps = this.getStartPDBStateCommandExecutionSteps(configGraph, patchTarget, "RACDBInstance");
                            postDatapatchSteps.addAll(steps);
                        }
                    }
                }
            }
            catch (OPatchAutoException e) {
                this._logger.info(e.getMessage());
                patchActionResult = new PatchActionResult((Throwable)e);
                return patchActionResult;
            }
            boolean stepsGenerated = false;
            if (preDatapatchSteps != null && !preDatapatchSteps.isEmpty() || datapatchSteps != null && !datapatchSteps.isEmpty() || postDatapatchSteps != null && !postDatapatchSteps.isEmpty()) {
                stepsGenerated = true;
            }
            if (stepsGenerated) {
                this.preOperation(patchTarget);
                TrackOOPSessions.startPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName());
            }
            if (preDatapatchSteps != null && !preDatapatchSteps.isEmpty()) {
                patchActionResult = this.executeSteps(preDatapatchSteps, patchTarget);
            }
            if (datapatchSteps != null && !datapatchSteps.isEmpty() && !patchActionResult.isFailure() && (patchActionResult = this.executeStepsInParallel(datapatchSteps, patchTarget)).isFailure()) {
                String session = this.getPatchSession().isRollback() ? this.getLocalizedString("rolledback.session.value", new Object[0]) : this.getLocalizedString("applied.session.value", new Object[0]);
                Reporting.report((String)this.getLocalizedString("SQLAction.sql.patch.warning", patchActionResult.getDetails(), session));
                patchActionResult = new PatchActionResult(PatchActionStatus.success);
            }
            if (postDatapatchSteps != null && !postDatapatchSteps.isEmpty() && !patchActionResult.isFailure()) {
                patchActionResult = this.executeSteps(postDatapatchSteps, patchTarget);
            }
            if (!stepsGenerated) break block51;
            try {
                this.postOperation(patchTarget);
            }
            catch (OPatchAutoException e) {
                this._logger.info(e.getMessage());
                patchActionResult = new PatchActionResult((Throwable)e);
            }
            TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
            break block51;
            catch (OPatchAutoException e) {
                try {
                    this._logger.info(e.getMessage());
                    patchActionResult = new PatchActionResult((Throwable)e);
                    if (!stepsGenerated) break block51;
                }
                catch (Throwable throwable) {
                    if (stepsGenerated) {
                        try {
                            this.postOperation(patchTarget);
                        }
                        catch (OPatchAutoException e2) {
                            this._logger.info(e2.getMessage());
                            patchActionResult = new PatchActionResult((Throwable)e2);
                        }
                        TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
                    }
                    throw throwable;
                }
                try {
                    this.postOperation(patchTarget);
                }
                catch (OPatchAutoException e3) {
                    this._logger.info(e3.getMessage());
                    patchActionResult = new PatchActionResult((Throwable)e3);
                }
                TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
            }
        }
        return patchActionResult;
    }

    private List<ExecutionStep> generateStepsForSIDatabase(PatchTarget patchTarget, String commandType, boolean actsOnClone) {
        ArrayList<ExecutionStep> sidbSteps = new ArrayList<ExecutionStep>();
        ArrayList<ExecutionStep> sidbRunning = new ArrayList<ExecutionStep>();
        try {
            ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
            sidbSteps.addAll(this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, commandType, "SIDatabase", actsOnClone));
            List<SIDatabase> sidbs = configGraph.getTargets(SIDatabase.class);
            for (SIDatabase sidb : sidbs) {
                if (!DBPatchingHelper.compareFilePath(sidb.getOracleHome(), patchTarget.getHome(true).getLocation())) continue;
                if (sidb.getAvailability().equals("yes")) {
                    block3: for (ExecutionStep step : sidbSteps) {
                        for (ExecutionStep.Command cmd : (ArrayList)step.getCommand()) {
                            String reference;
                            String command = cmd.getValue();
                            if (!command.contains(reference = "ORACLE_SID=" + sidb.getInstanceName())) continue;
                            sidbRunning.add(step);
                            continue block3;
                        }
                    }
                    continue;
                }
                this._logger.info("[Warning] Skipping steps for inactive database instance " + sidb.getInstanceName());
            }
        }
        catch (OPatchAutoException e) {
            this._logger.info(e.getMessage());
        }
        return sidbRunning;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        List<ExecutionStep> steps = null;
        if (isTwelveVersion) {
            steps = this.getStartRedoApplyCommandExecutionSteps(configGraph, patchTarget, null, "RACDatabase");
            generatedSteps.addAll(steps);
        }
        boolean actsOnClone = patchTarget.isUsingHomeClone();
        if (isTwelveVersion) {
            boolean isSQLPatchInUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
            if (isSQLPatchInUpgradeMode) {
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchDisableCluster.toString(), "RACDatabase", "SQL-Disable-Cluster-Step-Title", actsOnClone);
                generatedSteps.addAll(steps);
                if (this.isSQLUpgrdeModeCommandRequired(steps)) {
                    steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.stopOnAllHost.toString(), "rac", ServiceStatus.DOWN, "OracleHome", "Stop-Home-Title", "Stop-Home-Message");
                    generatedSteps.addAll(steps);
                }
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchStartupUpgradeMode.toString(), "RACDatabase", "SQL-Startup-Upgrade-Mode-Step-Title", actsOnClone);
                generatedSteps.addAll(steps);
                if (this.isSQLUpgrdeModeCommandRequired(steps)) {
                    steps = this.getUpgradePDBStateCommandExecutionSteps(configGraph, patchTarget, "RACDBInstance");
                    generatedSteps.addAll(steps);
                }
            }
            if (this.getPatchSession().isRollback()) {
                if (DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
                    steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchSwitchback.toString(), "RACDatabase", actsOnClone);
                    generatedSteps.addAll(steps);
                }
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchRollback.toString(), "RACDatabase", actsOnClone);
                generatedSteps.addAll(steps);
            } else {
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchApply.toString(), "RACDatabase", actsOnClone);
                generatedSteps.addAll(steps);
            }
            if (isSQLPatchInUpgradeMode) {
                steps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchEnableCluster.toString(), "RACDatabase", "SQL-Startup-Enable-Cluster-Step-Title", actsOnClone);
                generatedSteps.addAll(steps);
                if (this.isSQLUpgrdeModeCommandRequired(steps)) {
                    steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.startOnAllHost.toString(), "rac", ServiceStatus.UP, "OracleHome", "Start-Home-Title", "Start-Home-Message");
                    generatedSteps.addAll(steps);
                    steps = this.getStartPDBStateCommandExecutionSteps(configGraph, patchTarget, "RACDBInstance");
                    generatedSteps.addAll(steps);
                }
            }
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }
}

