/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.SQLCommandModel;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class PDBActions {
    private boolean isRollback = false;
    private final Logger _logger = Logger.getLogger(PDBActions.class.getName());

    public PDBActions(boolean isRollback) {
        this.isRollback = isRollback;
    }

    public PDBCOmmandModel getSavePDBStateCommand(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on) throws OPatchAutoException {
        String savePDBCommand = "DECLARE \nl_count NUMBER(4) :=0; \nBEGIN \nSELECT count(*) INTO l_count FROM CDB_PDBS; \nIF l_count >1 then \nEXECUTE IMMEDIATE 'alter pluggable database ALL SAVE STATE'; \nEND IF; \ncommit; \nEND;";
        String sqlExecuteCommand = "/";
        PDBCOmmandModel pdbCommand = this.getPDBStateCommand(configGraph, patchTarget, DBCommandActionType.savePDBState.toString(), acts_on, savePDBCommand, sqlExecuteCommand);
        return pdbCommand;
    }

    public PDBCOmmandModel getStartPDBStateCommand(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on) throws OPatchAutoException {
        String startPDBCommand = "DECLARE \nl_count NUMBER(4) :=0; \nBEGIN \nSELECT count(*) INTO l_count FROM CDB_PDBS; \nIF l_count >1 then \nEXECUTE IMMEDIATE 'alter pluggable database ALL OPEN'; \nEND IF; \ncommit; \nEND;";
        String sqlExecuteCommand = "/";
        PDBCOmmandModel pdbCommand = this.getPDBStateCommand(configGraph, patchTarget, DBCommandActionType.startPDB.toString(), acts_on, startPDBCommand, sqlExecuteCommand);
        return pdbCommand;
    }

    public PDBCOmmandModel getUpgradePDBStateCommand(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on) throws OPatchAutoException {
        String upgradePDBCommand = "DECLARE \nl_count NUMBER(4) :=0; \nBEGIN \nSELECT count(*) INTO l_count FROM CDB_PDBS; \nIF l_count >1 then \nEXECUTE IMMEDIATE 'alter pluggable database all open upgrade'; \nEND IF; \ncommit; \nEND;";
        String sqlExecuteCommand = "/";
        PDBCOmmandModel pdbCommand = this.getPDBStateCommand(configGraph, patchTarget, DBCommandActionType.upgradePDB.toString(), acts_on, upgradePDBCommand, sqlExecuteCommand);
        return pdbCommand;
    }

    private PDBCOmmandModel getPDBStateCommand(ConfigGraph configGraph, PatchTarget patchTarget, String commandType, String acts_on, String ... pdbCommandStr) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, commandType);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, acts_on);
        argList.put(CommandDetailsGenerator.ActionTypeParams.SQL_ACTION_CONNECT_AS, DBCommandParameters.SYSDBA.getValue());
        this.setReadMe(argList, commandType, acts_on);
        ArrayList<SQLCommandModel> sqlCommandList = new ArrayList<SQLCommandModel>();
        for (String sqlCommand : pdbCommandStr) {
            SQLCommandModel model = new SQLCommandModel(sqlCommand, "no error", null);
            sqlCommandList.add(model);
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.SQL_ACTION_COMMANDS, sqlCommandList);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.APPLY_SQL_ACTION, argList);
        PatchingPhase phase = this.getPatchingPhase();
        Command pdbStateCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        return new PDBCOmmandModel(actionType, pdbStateCommand);
    }

    private PatchingPhase getPatchingPhase() {
        PatchingPhase phase = null;
        phase = this.isRollback ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.ROLLBACK, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.LIMITED);
        return phase;
    }

    private void setReadMe(Map<CommandDetailsGenerator.ActionTypeParams, Object> argList, String commandType, String acts_on) {
        if (DBCommandActionType.discardPDBState.toString().equals(commandType)) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Discard-PDB-State-Title");
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Discard-PDB-State-Message");
        } else if (DBCommandActionType.savePDBState.toString().equals(commandType)) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Save-PDB-Title");
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Save-PDB-Message");
        } else if (DBCommandActionType.startPDB.toString().equals(commandType)) {
            if (acts_on.equals("SIDatabase")) {
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-SIDB-PDB-Title");
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-SIDB-PDB-Message");
            } else {
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-PDB-Title");
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-PDB-Message");
            }
        } else if (DBCommandActionType.upgradePDB.toString().equals(commandType)) {
            if (acts_on.equals("SIDatabase")) {
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-UPGRADE-SIDB-PDB-Title");
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-UPGRADE-SIDB-PDB-Message");
            } else {
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-PDB-UPGRADE-Title");
                argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-PDB-UPGRADE-Message");
            }
        }
    }

    public boolean isPDBCommandNeedToBeExecuted(PatchSession session, PatchTarget target, String homePath, String user, String command, String actOn, String version) {
        boolean isRequired = true;
        String instName = DBPatchingUtil.getInstNameUsingCommand(command);
        boolean isDBUp = true;
        String dbname = "";
        if (((HomeImpl)target.getHome()).isGIMRHome()) {
            return false;
        }
        if (actOn.equals("SIDatabase")) {
            dbname = DBPatchingUtil.getSIDBNameFromInstancename(instName, target);
            if (!DBPatchingHelper.isStaticConfiguration(session.getOptions())) {
                isDBUp = DBPatchingUtil.isDBUpOnSIHA(homePath, dbname, user, target, version);
            }
        } else {
            dbname = DBPatchingUtil.getRACDBNameFromInstancename(instName, target);
            if (!DBPatchingHelper.isStaticConfiguration(session.getOptions())) {
                isDBUp = DBPatchingUtil.isRACOneDB(dbname) ? DBPatchingUtil.isRACOneDBUp(homePath, dbname, target.getHost().getHost(), user, target, version) : DBPatchingUtil.isDBInstanceUp(homePath, dbname, target.getHost().getHost(), user, target, version);
            }
        }
        if (StringUtil.isNullOrEmpty((String)dbname, (boolean)true) && instName != null) {
            this._logger.log(Level.INFO, "Database instance \"" + instName + "\" is not running. PDB instances on the current node will not be checked.");
            isRequired = false;
        }
        if (!isDBUp) {
            this._logger.log(Level.INFO, "Database \"" + dbname + "\" is not running. PDB instances on the current node will not be checked.");
            isRequired = false;
        }
        return isRequired;
    }

    public class PDBCOmmandModel {
        private final ActionType actionType;
        private final Command pdbCommand;

        public PDBCOmmandModel(ActionType actionType, Command command) {
            this.actionType = actionType;
            this.pdbCommand = command;
        }

        public ActionType getActionType() {
            return this.actionType;
        }

        public Command getPdbCommand() {
            return this.pdbCommand;
        }
    }
}

