/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.TrackOOPSessions;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PrereqAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import dbmodel.db_crs.SIDatabase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DBPrereqAction
extends PrereqAction {
    public DBPrereqAction() {
        super((Goal)InitPhase.Goal.init);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        if (DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions())) {
            return false;
        }
        if (((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        return super.isActionRequired(patchTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult;
        block38: {
            ArrayList<ExecutionStep> sqlPatchSteps;
            List<ExecutionStep> spFilePrereqSteps;
            block36: {
                String msg;
                block37: {
                    patchActionResult = new PatchActionResult();
                    spFilePrereqSteps = null;
                    sqlPatchSteps = new ArrayList<ExecutionStep>();
                    ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
                    String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
                    String dbTargetHomeConstant = "";
                    String type = patchTarget.getProductType().getType();
                    if (type.equals(DBProductTypes.PRODUCT_TYPE_SIDB.getValue())) {
                        dbTargetHomeConstant = "SIDatabase";
                        if (this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue() != null) {
                            primarypatchVersion = configGraph.getTargets(SIDatabase.class).get(0).getShardProperty().getShardVersion();
                        }
                    } else {
                        dbTargetHomeConstant = "RACDatabase";
                    }
                    boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
                    this._logger.info("dbTargetHomeConstant " + dbTargetHomeConstant);
                    if (isTwelveVersion) {
                        spFilePrereqSteps = this.getSPFilePreReqCommandExecutionSteps(configGraph, patchTarget, dbTargetHomeConstant);
                    }
                    if (isTwelveVersion) {
                        List<ExecutionStep> steps;
                        if (this.getPatchSession().isRollback()) {
                            steps = this.getSQLpatchApplyCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchRollback.toString(), dbTargetHomeConstant);
                            if (DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions()) || !type.equals(DBProductTypes.PRODUCT_TYPE_RAC.getValue())) {
                                sqlPatchSteps.addAll(steps);
                                if (dbTargetHomeConstant != "SIDatabase") {
                                    sqlPatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchRollback.toString()));
                                } else {
                                    sqlPatchSteps.clear();
                                    sqlPatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchRollback.toString()));
                                }
                            } else {
                                sqlPatchSteps.addAll(DBPatchingHelper.filterLastNodeSteps(patchTarget, steps, this.getPatchSession().isRollback()));
                                if (dbTargetHomeConstant != "SIDatabase") {
                                    sqlPatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchRollback.toString()));
                                }
                            }
                        } else {
                            steps = this.getSQLpatchApplyCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchApply.toString(), dbTargetHomeConstant);
                            if (DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions()) || !type.equals(DBProductTypes.PRODUCT_TYPE_RAC.getValue())) {
                                this._logger.info("Adding all steps because it is OOP or non-RAC");
                                sqlPatchSteps.addAll(steps);
                                if (dbTargetHomeConstant != "SIDatabase") {
                                    sqlPatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchApply.toString()));
                                } else {
                                    sqlPatchSteps.clear();
                                    sqlPatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchApply.toString()));
                                }
                            } else {
                                sqlPatchSteps.addAll(DBPatchingHelper.filterLastNodeSteps(patchTarget, steps, this.getPatchSession().isRollback()));
                                if (dbTargetHomeConstant != "SIDatabase") {
                                    sqlPatchSteps.addAll(this.generateStepsForSIDatabase(patchTarget, DBCommandActionType.SqlPatchApply.toString()));
                                }
                            }
                        }
                    }
                    if (sqlPatchSteps.isEmpty()) {
                        msg = "No sqlpatch prereq operations are required on the local node for this home";
                        Reporting.report((String)msg);
                        this._logger.info(msg + " : " + patchTarget.getHome(true).getLocation());
                    } else {
                        this._logger.info("datapatch will be run on " + sqlPatchSteps.size() + " instances.");
                    }
                    if (spFilePrereqSteps != null && !spFilePrereqSteps.isEmpty() || sqlPatchSteps != null && !sqlPatchSteps.isEmpty()) {
                        this.preOperation(patchTarget);
                        TrackOOPSessions.startPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName());
                        break block36;
                    }
                    patchActionResult = new PatchActionResult(PatchActionStatus.skipped);
                    this.displayNoStepMessage(patchTarget);
                    msg = patchActionResult;
                    if ((spFilePrereqSteps == null || spFilePrereqSteps.isEmpty()) && (sqlPatchSteps == null || sqlPatchSteps.isEmpty())) break block37;
                    try {
                        this.postOperation(patchTarget);
                    }
                    catch (OPatchAutoException e) {
                        this._logger.info(e.getMessage());
                        patchActionResult = new PatchActionResult((Throwable)e);
                    }
                    TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
                }
                return msg;
            }
            if (spFilePrereqSteps != null && !spFilePrereqSteps.isEmpty()) {
                patchActionResult = this.executeSteps(spFilePrereqSteps, patchTarget);
            }
            if (sqlPatchSteps != null && !sqlPatchSteps.isEmpty() && !patchActionResult.isFailure() && (patchActionResult = this.executeStepsInParallel(sqlPatchSteps, patchTarget)).isFailure()) {
                String session = this.getLocalizedString("analyzed.session.value", new Object[0]);
                Reporting.report((String)this.getLocalizedString("SQLAction.sql.patch.warning", patchActionResult.getDetails(), session));
                patchActionResult = new PatchActionResult(PatchActionStatus.success);
            }
            if ((spFilePrereqSteps == null || spFilePrereqSteps.isEmpty()) && (sqlPatchSteps == null || sqlPatchSteps.isEmpty())) break block38;
            try {
                this.postOperation(patchTarget);
            }
            catch (OPatchAutoException e) {
                this._logger.info(e.getMessage());
                patchActionResult = new PatchActionResult((Throwable)e);
            }
            TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
            break block38;
            catch (OPatchAutoException e) {
                try {
                    this._logger.info(e.getMessage());
                    patchActionResult = new PatchActionResult((Throwable)e);
                    if ((spFilePrereqSteps == null || spFilePrereqSteps.isEmpty()) && (sqlPatchSteps == null || sqlPatchSteps.isEmpty())) break block38;
                }
                catch (Throwable throwable) {
                    if (spFilePrereqSteps != null && !spFilePrereqSteps.isEmpty() || sqlPatchSteps != null && !sqlPatchSteps.isEmpty()) {
                        try {
                            this.postOperation(patchTarget);
                        }
                        catch (OPatchAutoException e2) {
                            this._logger.info(e2.getMessage());
                            patchActionResult = new PatchActionResult((Throwable)e2);
                        }
                        TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
                    }
                    throw throwable;
                }
                try {
                    this.postOperation(patchTarget);
                }
                catch (OPatchAutoException e3) {
                    this._logger.info(e3.getMessage());
                    patchActionResult = new PatchActionResult((Throwable)e3);
                }
                TrackOOPSessions.endPatchAction(patchTarget.getHome().getLocation(), ((Object)((Object)this)).getClass().getName(), !patchActionResult.isFailure());
            }
        }
        return patchActionResult;
    }

    private List<ExecutionStep> generateStepsForSIDatabase(PatchTarget patchTarget, String commandType) {
        ArrayList<ExecutionStep> sidbSteps = new ArrayList<ExecutionStep>();
        ArrayList<ExecutionStep> sidbRunning = new ArrayList<ExecutionStep>();
        try {
            ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
            sidbSteps.addAll(this.getSQLpatchApplyCommandExecutionSteps(configGraph, patchTarget, commandType, "SIDatabase"));
            List<SIDatabase> sidbs = configGraph.getTargets(SIDatabase.class);
            for (SIDatabase sidb : sidbs) {
                if (!DBPatchingHelper.compareFilePath(sidb.getOracleHome(), patchTarget.getHome(true).getLocation())) continue;
                if (sidb.getAvailability().equals("yes")) {
                    block3: for (ExecutionStep step : sidbSteps) {
                        for (ExecutionStep.Command cmd : (ArrayList)step.getCommand()) {
                            String reference;
                            String command = cmd.getValue();
                            if (!command.contains(reference = "ORACLE_SID=" + sidb.getInstanceName())) continue;
                            sidbRunning.add(step);
                            continue block3;
                        }
                    }
                    continue;
                }
                this._logger.info("[Warning] Skipping steps for inactive database instance " + sidb.getInstanceName());
            }
        }
        catch (OPatchAutoException e) {
            this._logger.info(e.getMessage());
        }
        return sidbRunning;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue());
        return targetList;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("DBPrereqAction.start.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("DBPrereqAction.failure.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("DBPrereqAction.warning.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("DBPrereqAction.success.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        statusMsg = this.addTag(statusMsg);
        return statusMsg;
    }
}

