/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.readme;

import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionPlan;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.VariableResolver;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeDecorator;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeFactory;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeGenerator;
import com.oracle.glcm.patch.auto.db.framework.sdk.resource.PatchPlanBundle;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.SqlCommand;

public abstract class ReadmeGeneratorBase
implements ReadmeGenerator {
    protected ReadmeFactory rf;
    protected final String STEP = PatchPlanBundle.getReadmeMessage("STEP", new Object[0]) + " ";
    protected final String TROUBLE = PatchPlanBundle.getReadmeMessage("TROUBLESHOOT", new Object[0]);
    protected List<ExecutionPlan> allPlans;
    private ReadmeDecorator decor;

    public ReadmeGeneratorBase(ReadmeFactory rf) {
        this.rf = rf;
    }

    @Override
    public abstract List<File> logStepsInReadme(List<ExecutionStep> var1) throws IOException;

    protected abstract File getReadmeFile();

    protected void setDecoratorContext(ReadmeDecorator decor) {
        this.decor = decor;
    }

    protected String getTitle(ExecutionStep step) {
        String title = "";
        if (step.getReadme() != null) {
            title = this.resolveVariables(PatchPlanBundle.getATitle(step.getReadme()), step);
        }
        return title;
    }

    protected String getMessage(ExecutionStep step) {
        String msg = "";
        if (step.getReadme() != null) {
            msg = this.resolveVariables(PatchPlanBundle.getStepMessage(step.getReadme()), step);
        }
        return msg;
    }

    protected String getTroubleshoot(ExecutionStep step) {
        String troubleShoot = "";
        if (step.getReadme() != null) {
            troubleShoot = this.resolveVariables(PatchPlanBundle.getStepTroubleshoot(step.getReadme()), step);
        }
        return troubleShoot;
    }

    protected String getTargetName(ExecutionPlan plan) {
        return plan.getApplyTarget().get(0).getValue();
    }

    protected String resolveVariables(String str, ExecutionStep step) {
        if (str == null || str.trim().equals("")) {
            return null;
        }
        String ret = VariableResolver.replaceContextProperties(str, step.getStepProperties());
        if (ret == null) {
            return null;
        }
        return MessageFormat.format(ret, this.decor.startHighlight(), this.decor.endHighlight());
    }

    protected String getCommandErrorMessage(ExecutionStep.Command cmd, ExecutionStep step) {
        SqlCommand.ErrorHandling.FatalError ferror = cmd.getErrorMessage();
        String error = PatchPlanBundle.getErrorMessage(ferror);
        if (error != null) {
            String resolved = this.resolveVariables(error, step);
            return resolved;
        }
        return null;
    }
}

