/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.readme;

import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.ReadmeFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class Cmds2Script {
    private static FileWriter fw;

    public static void initialize() throws IOException {
        File ret = Cmds2Script.getScriptFile();
        fw = new FileWriter(ret, true);
    }

    public static void deInitalize() throws IOException {
        fw.close();
        fw = null;
    }

    public static void cmds2ScriptFile(List<ExecutionStep> steps) throws IOException {
        Cmds2Script.writeCmds(fw, steps, "_._");
    }

    private static File getScriptFile() {
        String customReadmeFilePath = System.getProperty("CUSTOM_README_FILE_PATH");
        if (customReadmeFilePath != null) {
            return new File(customReadmeFilePath);
        }
        return new File(PatchPlanner.getInstance().getLogInfo().getHiddenFilesDir(), ReadmeFactory.getInstance().getBundleMessagePrefix() + ".tmp");
    }

    private static void writeCmds(FileWriter fw, List<ExecutionStep> steps, String stepPrefix) throws IOException {
        fw.write("_:\n");
        fw.write("_._:\n");
        for (ExecutionStep step : steps) {
            if (step.getCommand().isEmpty()) continue;
            fw.write(stepPrefix + "._:\n");
            fw.write("## " + step.getUser().getValue() + "@" + step.getHost().getHostName() + "\n");
            for (ExecutionStep.Command cmd : step.getCommand()) {
                if (cmd == null || cmd.getValue() == null || cmd.getValue().trim().equals("")) continue;
                String cmdStr = cmd.getValue().replaceAll("//", "/");
                fw.write(cmdStr.trim() + "\n");
            }
        }
    }
}

