/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.exec.api;

import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionPlan;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="execution-phase", namespace="http://oracle.com/schema/opatch/ExecutionPlan", propOrder={"applyTarget", "readme", "executionStep"})
public class ExecutionPhase
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="execution-step", required=true)
    protected List<ExecutionStep> executionStep;
    @XmlTransient
    protected PatchingPhase automationPatchingPhase;
    @XmlTransient
    protected PhaseType phaseType = PhaseType.PRE_PATCH;
    @XmlTransient
    protected ServiceStatus serviceStatus = ServiceStatus.UP;
    @XmlTransient
    private ExecutionPlan executionPlan;
    private String status;

    public ExecutionPhase() {
    }

    public ExecutionPhase(PatchingPhase automationPhase, PhaseType phaseType, ServiceStatus downtimeType, ExecutionPlan plan) {
        if (plan == null) {
            throw new IllegalArgumentException("Plan cannot be null!");
        }
        this.automationPatchingPhase = automationPhase;
        this.executionPlan = plan;
        this.phaseType = phaseType;
        this.serviceStatus = downtimeType;
    }

    public List<ExecutionStep> getExecutionStep() {
        if (this.executionStep == null) {
            this.executionStep = new MyList<ExecutionStep>();
        }
        return this.executionStep;
    }

    public ExecutionPlan getExecutionPlan() {
        return this.executionPlan;
    }

    public void setPhaseType(PhaseType phaseType) {
        this.phaseType = phaseType;
    }

    public PhaseType getPhaseType() {
        return this.phaseType;
    }

    public void setServiceStatus(ServiceStatus serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public ServiceStatus getServiceStatus() {
        return this.serviceStatus;
    }

    public void setAutomationPatchingPhase(PatchingPhase automationPatchingPhase) {
        this.automationPatchingPhase = automationPatchingPhase;
    }

    public PatchingPhase getAutomationPatchingPhase() {
        return this.automationPatchingPhase;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public static enum PhaseType {
        ANALYSIS,
        PRE_PATCH,
        PATCH,
        POST_PATCH,
        POST_PATCH_GI,
        POST_PATCH_RAC;

    }

    class MyList<E extends ExecutionStep>
    extends ArrayList<E> {
        MyList() {
        }

        @Override
        public boolean add(E e) {
            ((ExecutionStep)e).setExecutionPlan(ExecutionPhase.this.executionPlan);
            return super.add(e);
        }

        @Override
        public void add(int index, E element) {
            ((ExecutionStep)element).setExecutionPlan(ExecutionPhase.this.executionPlan);
            super.add(index, element);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            for (ExecutionStep e : c) {
                e.setExecutionPlan(ExecutionPhase.this.executionPlan);
            }
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            for (ExecutionStep e : c) {
                e.setExecutionPlan(ExecutionPhase.this.executionPlan);
            }
            return super.addAll(index, c);
        }
    }
}

