/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.patchinfostore;

import com.oracle.glcm.patch.auto.db.framework.patchinfostore.PatchList;
import com.oracle.glcm.patch.auto.db.framework.patchtarget.PatchApplicableTarget;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="patching-information-list", propOrder={"sessionID", "patchInformation"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="patching-information-list")
public class PatchingInformation {
    @XmlElement(name="sessionid", required=true)
    private String sessionID = "";
    @XmlElementWrapper(name="patching-information")
    private ConcurrentMap<PatchApplicableTarget, PatchList> patchInformation = new ConcurrentHashMap<PatchApplicableTarget, PatchList>();

    void init(String sessionID) {
        this.sessionID = sessionID;
    }

    void storePatchInformation(PatchApplicableTarget target, String patchLoc) {
        if (this.patchInformation.containsKey(target)) {
            PatchList appliedPatchList = (PatchList)this.patchInformation.get(target);
            if (!appliedPatchList.containsObject(patchLoc)) {
                appliedPatchList.addPatchDetailsToList(patchLoc);
            }
        } else {
            PatchList patchList = new PatchList();
            patchList.addPatchDetailsToList(patchLoc);
            this.patchInformation.put(target, patchList);
        }
    }

    CopyOnWriteArrayList<String> getSuccessfulPatchList(PatchApplicableTarget target) {
        CopyOnWriteArrayList<String> patchList = new CopyOnWriteArrayList<String>();
        PatchList appliedpatches = null;
        if (this.patchInformation.containsKey(target)) {
            appliedpatches = (PatchList)this.patchInformation.get(target);
            patchList = appliedpatches.getPatchList();
        }
        return patchList;
    }

    String getSessionID() {
        return this.sessionID;
    }

    void clear() {
        this.patchInformation.clear();
    }
}

