/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.core.patch;

import com.oracle.glcm.patch.auto.db.framework.core.patch.PatchInventory;
import dbmodel.patchmodel.CompositePatch;
import dbmodel.patchmodel.GenericSingletonPatch;
import dbmodel.patchmodel.OPatchSingleton;
import dbmodel.patchmodel.PatchingTool;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PatchUtils {
    public static final String XML_TAG_TEXT = "#text";
    public static final String XML_COMPOSITE_SEQUENCE = "sequence";
    public static final String XML_TAG_COMMENT = "#comment";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer().toString();
    }

    public static List<String> getAutoXmlsFromZipStreamMap(Map zipStreamMap) throws PatchPackageException {
        ArrayList<byte[]> automationList = new ArrayList<byte[]>();
        Map autoStreamMap = (Map)zipStreamMap.get("AUTOMATION_XMLS");
        Iterator autoStreamIterator = autoStreamMap.values().iterator();
        while (autoStreamIterator.hasNext()) {
            automationList.add((byte[])autoStreamIterator.next());
        }
        ArrayList<String> automationXmls = new ArrayList<String>();
        if (automationList != null && !automationList.isEmpty()) {
            for (byte[] automationXml : automationList) {
                try {
                    automationXmls.add(PatchUtils.getContent(new ByteArrayInputStream(automationXml)));
                }
                catch (IOException e) {
                    throw new PatchPackageException("Couldn't read the automationXmls", (Throwable)e);
                }
            }
        }
        return automationXmls;
    }

    public static String[] getBundleXmlFromZipStreamMap(Map zipStreamMap) throws PatchPackageException {
        try {
            String[] bundleXML = new String[2];
            Object[] bundleXMLArray = (Object[])zipStreamMap.get("BUNDLE_XML");
            if (bundleXMLArray.length == 0) {
                return null;
            }
            bundleXML[0] = (String)bundleXMLArray[0];
            bundleXML[1] = PatchUtils.getContent(new ByteArrayInputStream((byte[])bundleXMLArray[1]));
            return bundleXML;
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the input stream of bundle xml.");
        }
    }

    public static String getCompositeXMlFromZipStreamMap(Map zipStreamMap) throws PatchPackageException {
        try {
            String compositeXML = null;
            Map compositeMap = (Map)zipStreamMap.get("COMPOSITE_XML");
            for (byte[] compositeXmlStream : compositeMap.values()) {
                compositeXML = PatchUtils.getContent(new ByteArrayInputStream(compositeXmlStream));
            }
            return compositeXML;
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the input stream of composite xml.");
        }
    }

    public static String getMessagePropertyFromZipStreamMap(Map zipStreamMap) throws PatchPackageException {
        try {
            Object[] messageXMLArray = (Object[])zipStreamMap.get("MESSAGE_PROPERTIES");
            if (messageXMLArray.length == 2) {
                byte[] message = (byte[])messageXMLArray[1];
                return PatchUtils.getContent(new ByteArrayInputStream(message));
            }
            return null;
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the input stream.");
        }
    }

    public static String getPatchmdFromZipMap(String patchLoc, Map zipStreamMap) throws PatchPackageException {
        try {
            Map patchmdMap = (Map)zipStreamMap.get("PATCHMD_XML");
            if (patchmdMap == null) {
                return null;
            }
            String patchmdXML = null;
            byte[] patchmdByte = (byte[])patchmdMap.get(patchLoc);
            if (patchmdByte == null) {
                return null;
            }
            patchmdXML = PatchUtils.getContent(new ByteArrayInputStream(patchmdByte));
            return patchmdXML;
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the input stream of patchmd xml.");
        }
    }

    public static String getPatchmdFromZipMap(Map zipStreamMap) throws PatchPackageException {
        try {
            Map patchmdMap = (Map)zipStreamMap.get("PATCHMD_XML");
            if (patchmdMap == null) {
                return null;
            }
            String patchmdXML = null;
            for (byte[] patchmdXmlStream : patchmdMap.values()) {
                patchmdXML = PatchUtils.getContent(new ByteArrayInputStream(patchmdXmlStream));
            }
            return patchmdXML;
        }
        catch (IOException e) {
            throw new PatchPackageException("Exception while reading the input stream of patchmd xml.");
        }
    }

    public static PatchInventory[] getPatchInventoryFromZipMap(Map map) {
        HashMap patchInventoryMap = (HashMap)map.get("PATCH_INVENTORY");
        PatchInventory[] PatchInventoryList = new PatchInventory[patchInventoryMap.values().size()];
        patchInventoryMap.values().toArray(PatchInventoryList);
        return PatchInventoryList;
    }

    public static PatchInventory getPatchInventoryByPatchIDFromMap(Map map, String patchID) {
        PatchInventory[] inventoryList = PatchUtils.getPatchInventoryFromZipMap(map);
        for (int i = 0; i < inventoryList.length; ++i) {
            PatchInventory inventory = inventoryList[i];
            if (!inventory.getPatchID().equals(patchID)) continue;
            return inventory;
        }
        return null;
    }

    public static List<String> getSubPatchesOfCompositePatch(InputStream compositeInputStream) throws PatchPackageException {
        if (compositeInputStream == null) {
            return null;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(compositeInputStream);
            Node composite_node = document.getFirstChild();
            NodeList children_of_composite = composite_node.getChildNodes();
            int j = 0;
            for (j = 0; j < children_of_composite.getLength() && !children_of_composite.item(j).getNodeName().equals(XML_COMPOSITE_SEQUENCE); ++j) {
            }
            Node sequence_node = children_of_composite.item(j);
            NodeList patch_list = sequence_node.getChildNodes();
            ArrayList<String> subPatches = new ArrayList<String>();
            for (int i = 0; i < patch_list.getLength(); ++i) {
                if (patch_list.item(i).getNodeName().equals(XML_TAG_TEXT) || patch_list.item(i).getNodeName().equals(XML_TAG_COMMENT)) continue;
                Element cur_node = (Element)patch_list.item(i);
                subPatches.add(cur_node.getAttribute("id"));
            }
            return subPatches;
        }
        catch (ParserConfigurationException e) {
            throw new PatchPackageException(e.getMessage());
        }
        catch (SAXException e) {
            throw new PatchPackageException(e.getMessage());
        }
        catch (IOException e) {
            throw new PatchPackageException(e.getMessage());
        }
    }

    public static boolean isCompositeSubPatch(String patchloc, Map map) {
        Map compositeMap = (Map)map.get("COMPOSITE_XML");
        return compositeMap.containsKey(patchloc);
    }

    public static CompositePatch getCompositePatch(Map map, String patchLoc) throws PatchPackageException {
        Map compositeMap = (Map)map.get("COMPOSITE_XML");
        if (!compositeMap.containsKey(patchLoc)) {
            return null;
        }
        CompositePatch compositePatch = new CompositePatch();
        compositePatch.setPatchLocation(patchLoc);
        byte[] compositBytes = (byte[])compositeMap.get(patchLoc);
        List<String> subPatchIDs = PatchUtils.getSubPatchesOfCompositePatch(new ByteArrayInputStream(compositBytes));
        ArrayList<OPatchSingleton> subPatches = new ArrayList<OPatchSingleton>();
        if (subPatchIDs.size() == 0) {
            throw new PatchPackageException("Invalid Bundle patch format, Could not get subpatch of the sub composite patch.");
        }
        for (String subPatchID : subPatchIDs) {
            OPatchSingleton subPatch = new OPatchSingleton();
            String subPatchLoc = patchLoc + File.separator + subPatchID;
            subPatch.setPatchLocation(subPatchLoc);
            PatchInventory inventory = PatchUtils.getPatchInventoryByPatchIDFromMap(map, subPatchID);
            if (inventory == null) {
                throw new PatchPackageException("can not found inventory for patch " + subPatchID + "with sub patch loc" + patchLoc);
            }
            PatchUtils.setSingletonPatchInfoByPatchInventory(subPatch, inventory);
            subPatches.add(subPatch);
            if (compositePatch.getPatchIdOfRollbackPatch() != null) continue;
            compositePatch.setPatchIdOfRollbackPatch(inventory.getConstituentID());
            compositePatch.setPatchID(inventory.getConstituentID());
        }
        compositePatch.setPatchLocation(patchLoc);
        compositePatch.setSubPatches(subPatches);
        compositePatch.setPatchTool(PatchUtils.getPatchTool());
        String minOPatchVersion = null;
        boolean isRollingPatch = true;
        boolean isInstanceShutdownPatch = false;
        boolean instanceShutdownPatchIsNull = true;
        boolean isSqlPatch = false;
        List supportedPlatforms = null;
        for (GenericSingletonPatch spatch : compositePatch.getSubPatches()) {
            if (!(spatch instanceof OPatchSingleton)) continue;
            OPatchSingleton subPatch = (OPatchSingleton)spatch;
            if (subPatch.getMinimumOPatchVersion() != null) {
                if (minOPatchVersion == null) {
                    minOPatchVersion = subPatch.getMinimumOPatchVersion();
                } else if (subPatch.getMinimumOPatchVersion().compareToIgnoreCase(minOPatchVersion) > 0) {
                    minOPatchVersion = subPatch.getMinimumOPatchVersion();
                }
            }
            isRollingPatch &= subPatch.getRollingPatch().booleanValue();
            if (subPatch.getInstanceShutdownPatch() != null) {
                instanceShutdownPatchIsNull = false;
                isInstanceShutdownPatch |= subPatch.getInstanceShutdownPatch().booleanValue();
            }
            isSqlPatch |= subPatch.getSqlPatch().booleanValue();
            if (supportedPlatforms == null) {
                supportedPlatforms = subPatch.getSupportedPlatforms();
                continue;
            }
            if (supportedPlatforms.equals(subPatch.getSupportedPlatforms())) continue;
            throw new PatchPackageException("The composite patch at location " + patchLoc + "contains" + "sub patches with different supported platforms");
        }
        if (instanceShutdownPatchIsNull) {
            isInstanceShutdownPatch = true;
        }
        compositePatch.setMinimumOPatchVersion(minOPatchVersion);
        compositePatch.setRollingPatch(new Boolean(isRollingPatch));
        compositePatch.setInstanceShutdownPatch(new Boolean(isInstanceShutdownPatch));
        compositePatch.setSqlPatch(new Boolean(isSqlPatch));
        compositePatch.setSupportedPlatforms(supportedPlatforms);
        return compositePatch;
    }

    public static void setSingletonPatchInfoByPatchInventory(OPatchSingleton patch, PatchInventory patchInventory) {
        patch.setPatchID(patchInventory.getPatchID());
        patch.setMinimumOPatchVersion(patchInventory.getMinimumOPatchVersion());
        patch.setInstanceShutdownPatch(Boolean.valueOf(patchInventory.isInstanctShutdownPatch()));
        patch.setSqlPatch(Boolean.valueOf(patchInventory.isSqlPatch()));
        patch.setRollingPatch(Boolean.valueOf(patchInventory.isRollingPatch()));
        Boolean isUpgrade = patchInventory.issqlPatchInUpgradeMode();
        if (isUpgrade != null) {
            patch.setSqlPatchUpgradeMode(isUpgrade);
        } else {
            patch.setSqlPatchUpgradeMode(Boolean.FALSE);
        }
    }

    private static String getPatchTool() {
        return PatchingTool.OPATCH.toString();
    }
}

