/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;

public class TrackOOPSessions {
    private static final Logger _logger = Logger.getLogger(TrackOOPSessions.class.getName());
    private ClusterInformationLoader.CrsType crsType;
    private static String oop_history_file = "";
    private static boolean validHistory = false;
    private static boolean isOOP = false;

    private TrackOOPSessions() {
    }

    private static String getFile() {
        if (!StringUtil.isNullOrEmpty((String)oop_history_file)) {
            return oop_history_file;
        }
        try {
            String gridHome = ClusterInformationLoader.getInstance().getGridHome();
            File homeDir = new File(gridHome);
            if (!homeDir.isDirectory()) {
                _logger.info("OOP history will not be updated since the grid home was not valid.\n");
                return null;
            }
            Credential credential = null;
            String opatchautoDB = gridHome + DBCommonPatchingConstants.CFGTOOLLOGS_OPATCHAUTODB;
            DBPatchingHelper.createPatchDirectory(gridHome, opatchautoDB, credential, "775");
            String hostname = DBPatchingHelper.getHostNameWithoutDomain(OPatchAutoHelper.getOPatchAutoHost());
            oop_history_file = opatchautoDB + "oop_history_" + hostname;
            _logger.fine("OOP history file is " + oop_history_file);
        }
        catch (Exception e) {
            _logger.info("OOP history will not be updated since the grid home was not detected.\n");
            return null;
        }
        return oop_history_file;
    }

    private static boolean createHistoryFile() {
        if (StringUtil.isNullOrEmpty((String)oop_history_file)) {
            return false;
        }
        File history = new File(oop_history_file);
        if (history.exists()) {
            return true;
        }
        try {
            history.createNewFile();
            DBPatchingHelper.changeOwner(ClusterInformationLoader.getInstance().getGridHome(), null, history);
            byte[] pwd = null;
            GISystemCall.ExecReturn ret = GISystemCall.process("chmod 664 " + history.getAbsolutePath(), "root", pwd);
            if (!ret.isOK()) {
                _logger.info("Failed to create OOP history file" + ret.getErrorMessage());
                return false;
            }
            return true;
        }
        catch (IOException e) {
            _logger.info("Failed to create OOP history file" + e.getMessage());
            return false;
        }
        catch (OPatchAutoException oe) {
            _logger.info("Failed to create OOP history file" + oe.getMessage());
            return false;
        }
    }

    public static void initialize(OPatchAutoOptions options) {
        isOOP = true;
        TrackOOPSessions.getFile();
        validHistory = TrackOOPSessions.createHistoryFile();
        if (validHistory) {
            TrackOOPSessions.append("\n======= New Session started at " + OPatchAutoHelper.getCurrentDateTimeStamp((String)"yyyy-MM-dd_hh-mm-ssa") + " =======\n");
            TrackOOPSessions.append(options);
        }
    }

    private static boolean append(OPatchAutoOptions options) {
        String text = "Options : ";
        for (OPatchAutoOption option : options.getAllOptions()) {
            if (option.isPassword()) continue;
            try {
                text = text + option.getArg() + " " + option.getValue() + " ";
            }
            catch (OPatchAutoException e) {
                _logger.finest("Unable to append options" + e.getMessage());
            }
        }
        return TrackOOPSessions.append(text);
    }

    public static boolean append(String text) {
        if (!validHistory || !isOOP) {
            return false;
        }
        File history = new File(oop_history_file);
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(history, true));
            output.write(text);
            output.newLine();
            output.close();
        }
        catch (IOException e) {
            _logger.finest("Unable to write to OOP history" + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean startPatchAction(String home, String action) {
        String status = "Action " + action + " started on home " + home;
        return TrackOOPSessions.append(status);
    }

    public static boolean endPatchAction(String home, String action, boolean successful) {
        String status = "Action " + action + (successful ? " SUCCEEDED " : " FAILED ") + "on home " + home;
        return TrackOOPSessions.append(status);
    }

    public static boolean endSession() {
        return TrackOOPSessions.append("\n======= Session Ended at " + OPatchAutoHelper.getCurrentDateTimeStamp((String)"yyyy-MM-dd_hh-mm-ssa") + " =======\n");
    }
}

