/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.EntropySource;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.Utils;

public class DSARandomBitsSource
extends RandomBitsSource {
    private static final int a = 20;
    private static final int b = 2000000;
    private final byte[] c = new byte[40];
    private final BigInt[] d = new BigInt[2];
    private BigInt e;
    private BigInt f;
    private int g;
    private int h;
    private boolean i = false;
    private int j;
    private MessageDigest k;

    public DSARandomBitsSource() {
        this(true);
    }

    public DSARandomBitsSource(boolean bl) {
        try {
            this.k = MessageDigest.getInstance(AlgID.sha1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
        if (bl) {
            this.seed();
        }
    }

    @Override
    public synchronized void clear() {
        if (this.e != null) {
            this.e.erase();
            this.e = null;
        }
        if (this.f != null) {
            this.f.erase();
            this.f = null;
        }
        this.g = 0;
        this.h = 0;
        this.a(this.d);
        DSARandomBitsSource.a(this.c);
        this.j = 0;
        this.i = false;
    }

    @Override
    public synchronized void seed(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        if (byArray.length < 20 || byArray.length > 64) {
            throw new IllegalArgumentException("Seed value must be between 20 bytes and 64 bytes in length.");
        }
        this.e = new BigInt(1, byArray);
        this.g = byArray.length * 8;
        this.i = true;
        this.a().initialize();
    }

    @Override
    public synchronized void seed(EntropySource entropySource) {
        this.seed(entropySource.generateBytes(new byte[20]));
    }

    @Override
    public synchronized byte randomByte() {
        if (!this.i) {
            throw new IllegalStateException("PRNG has not been seeded.");
        }
        FIPS_140_2.assertReadyState();
        if (this.f == null || this.j == this.c.length) {
            this.b();
            this.j = 0;
        }
        byte by = this.c[this.j++];
        this.a().testRandomByte(by);
        return by;
    }

    @Override
    public synchronized byte[] randomBytes(byte[] byArray) {
        int n;
        if (!this.i) {
            throw new IllegalStateException("PRNG has not been seeded.");
        }
        FIPS_140_2.assertReadyState();
        if (this.f == null) {
            this.b();
        }
        int n2 = byArray.length;
        System.arraycopy(this.c, this.j, byArray, 0, n);
        this.j += n;
        int n3 = n2;
        for (n = Math.min(this.c.length - this.j, n2); n < n3; n += this.c.length) {
            this.b();
            this.j = Math.min(this.c.length, n2 - n);
            System.arraycopy(this.c, 0, byArray, n, this.j);
        }
        this.a().testRandomBytes(byArray, 0, n2);
        return byArray;
    }

    private static void a(byte[] byArray) {
        if (byArray != null) {
            Utils.setArray(byArray, (byte)0);
        }
    }

    private void a(BigInt[] bigIntArray) {
        if (bigIntArray != null) {
            int n = bigIntArray.length;
            for (int i = 0; i < n; ++i) {
                if (bigIntArray[i] == null) continue;
                bigIntArray[i].erase();
                bigIntArray[i] = null;
            }
        }
    }

    private BigInt a(BigInt bigInt) {
        int n = (512 - this.g) / 8;
        byte[] byArray = new byte[64];
        Utils.toByteArray(bigInt, byArray, 0, n);
        return new BigInt(1, this.k.computeDigest(byArray));
    }

    private void b() {
        int n;
        DSARandomBitsSource.a(this.c);
        this.a(this.d);
        if (this.h == 2000000) {
            this.clear();
            this.seed();
        }
        for (n = 0; n < 2; ++n) {
            if (this.f != null) {
                this.f.erase();
            }
            this.f = this.e.mod(BigInt.TWO.pow(this.g));
            this.d[n] = this.a(this.f);
            if (this.e != null) {
                this.e.erase();
            }
            this.e = BigInt.ONE.add(this.f).add(this.d[n]).mod(BigInt.TWO.pow(this.g));
        }
        int n2 = this.d.length;
        for (n = 0; n < n2; ++n) {
            Utils.toByteArray(this.d[n], this.c, n * 20, 20);
        }
        ++this.h;
    }
}

