/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import com.oracle.cie.common.util.logging.EnvironmentUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AppIDAnalyzer {
    public static final String APPID = "oracle.cie.log.appid";
    public static final String APPID_MAIN_PREFIX = "oracle.cie.log.internal.appid.main_";
    public static final String APPID_CALLER_PREFIX = "oracle.cie.log.internal.appid.caller_";
    public static final String APPID_DEFAULT = "oracle.cie.log.internal.appid.default";
    private Properties _properties;
    private boolean _debug;

    public AppIDAnalyzer(Properties properties) {
        this._properties = properties;
        this._debug = EnvironmentUtil.isDebugMode();
    }

    public String getAppId() {
        String appId = null;
        if (this._properties.containsKey(APPID)) {
            return this._properties.get(APPID).toString();
        }
        StackTraceElement[] elems = new Throwable().getStackTrace();
        if (elems != null && elems.length > 0) {
            StackTraceElement first = elems[elems.length - 1];
            if (first != null && first.getMethodName().equals("main") && (appId = this._properties.getProperty(APPID_MAIN_PREFIX + first.getClassName())) != null) {
                if (this._debug) {
                    LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: APPID property set to \"" + appId + "\" based on the main class " + first.getClassName()));
                }
                return appId;
            }
            for (StackTraceElement elem : elems) {
                appId = this._properties.getProperty(APPID_CALLER_PREFIX + elem.getClassName());
                if (appId == null) continue;
                if (this._debug) {
                    LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: APPID property set to \"" + appId + "\" based on the caller class " + elem.getClassName()));
                }
                return appId;
            }
        }
        appId = this._properties.getProperty(APPID_DEFAULT);
        if (this._debug) {
            if (appId != null) {
                LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: APPID property set to default \"" + appId + "\""));
            } else {
                LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: APPID property set to hardcodded CIE \""));
            }
        }
        appId = appId != null ? appId : "CIE";
        return appId;
    }
}

