/*
 * Decompiled with CFR 0.152.
 */
package model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.Unmarshaller;
import model.SystemInstance;
import model.bundle_xml.Action;
import model.bundle_xml.Advisory;
import model.bundle_xml.Automation;
import model.bundle_xml.Channel;
import model.bundle_xml.OS;
import model.bundle_xml.Pair;
import model.bundle_xml.PayloadFormat;
import model.bundle_xml.Product;
import model.bundle_xml.Release;
import model.bundle_xml.RpmFile;
import model.bundle_xml.Script;
import model.bundle_xml.Subpatch;
import model.bundle_xml.SystemPatchBundleXML;
import model.bundle_xml.SystemTargetType;
import model.bundle_xml.TargetType;
import model.bundle_xml.fvalue;
import model.common.AbstractBaseTarget;
import model.common.EMtargetTypes;
import model.patchmodel.EngineeredSystemPatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.PatchType;
import model.patchmodel.PatchingTool;
import model.util.BundleValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleXmlUtilBase {
    protected static Logger logger = null;
    protected static String xsdFileName = "model/xml/system_patch_bundle.xsd";
    protected static String xmlFileName = "model/util/test/system_patch_bundle.xml";
    protected static String xmlV3FileName = "model/util/test/system_patch_bundle_v3.xml";
    protected Unmarshaller unmarshaller = null;

    protected Class[] getClasses() {
        return new Class[]{SystemPatchBundleXML.class, Subpatch.class, SystemTargetType.class, TargetType.class, Product.class, Release.class, Automation.class, fvalue.class, PatchingTool.class, PatchType.class, EMtargetTypes.class, Channel.class, RpmFile.class, Action.class, Advisory.class, PayloadFormat.class, OS.class, Script.class, Pair.class};
    }

    public static Map<AbstractBaseTarget, List<GenericPatch>> getTargetPatchMap(SystemInstance systemInstance, EngineeredSystemPatch engineeredSystemPatch) throws BundleValidationException {
        if (systemInstance == null || systemInstance.getEntities() == null || systemInstance.getEntities().isEmpty()) {
            throw new IllegalArgumentException(" System instance is empty");
        }
        if (engineeredSystemPatch == null) {
            throw new IllegalArgumentException(" System Patch is null");
        }
        if (engineeredSystemPatch.getSubPatches() == null || engineeredSystemPatch.getSubPatches().isEmpty()) {
            throw new BundleValidationException(" system patch does not contain any subpatches");
        }
        SystemPatchBundleXML systemPatchBundleXML = engineeredSystemPatch.getSystemPatchBundleXML();
        if (systemPatchBundleXML == null) {
            throw new BundleValidationException(" system patch does not contain SystemPatchBundleXML");
        }
        if (systemPatchBundleXML.getSubpatches() == null || systemPatchBundleXML.getSubpatches().isEmpty()) {
            throw new BundleValidationException(" system patch bundle does not contain any subpatch metadata");
        }
        HashMap<String, GenericPatch> hashMap = new HashMap<String, GenericPatch>();
        for (GenericPatch object : engineeredSystemPatch.getSubPatches()) {
            hashMap.put(object.getUPI(), object);
        }
        HashMap hashMap2 = new HashMap();
        for (Subpatch subpatch : systemPatchBundleXML.getSubpatches()) {
            if (subpatch.getTargetTypes() == null || subpatch.getTargetTypes().isEmpty()) continue;
            for (TargetType targetType : subpatch.getTargetTypes()) {
                List<AbstractBaseTarget> list = systemInstance.getTargetsOfEMTypeAndVersion(targetType);
                if (list == null || list.isEmpty()) continue;
                for (AbstractBaseTarget abstractBaseTarget : list) {
                    ArrayList arrayList = (ArrayList)hashMap2.get(abstractBaseTarget);
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                        hashMap2.put(abstractBaseTarget, arrayList);
                    }
                    arrayList.add(hashMap.get(subpatch.getUniquePatchID()));
                }
            }
        }
        return hashMap2;
    }

    public static Map<AbstractBaseTarget, List<Subpatch>> getTargetPatchMap(SystemInstance systemInstance, SystemPatchBundleXML systemPatchBundleXML) throws BundleValidationException {
        if (systemInstance == null || systemInstance.getEntities() == null || systemInstance.getEntities().isEmpty()) {
            throw new IllegalArgumentException(" System instance is empty");
        }
        if (systemPatchBundleXML == null) {
            throw new BundleValidationException(" system patch does not contain SystemPatchBundleXML");
        }
        if (systemPatchBundleXML.getSubpatches() == null || systemPatchBundleXML.getSubpatches().isEmpty()) {
            throw new BundleValidationException(" system patch bundle does not contain any subpatch metadata");
        }
        HashMap<AbstractBaseTarget, List<Subpatch>> hashMap = new HashMap<AbstractBaseTarget, List<Subpatch>>();
        for (Subpatch subpatch : systemPatchBundleXML.getSubpatches()) {
            if (subpatch.getTargetTypes() == null || subpatch.getTargetTypes().isEmpty()) continue;
            for (TargetType targetType : subpatch.getTargetTypes()) {
                List<AbstractBaseTarget> list = systemInstance.getTargetsOfEMTypeAndVersion(targetType);
                if (list == null || list.isEmpty()) continue;
                for (AbstractBaseTarget abstractBaseTarget : list) {
                    ArrayList<Subpatch> arrayList = (ArrayList<Subpatch>)hashMap.get(abstractBaseTarget);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Subpatch>();
                        hashMap.put(abstractBaseTarget, arrayList);
                    }
                    arrayList.add(subpatch);
                }
            }
        }
        return hashMap;
    }

    public static void setRebootRequired(Subpatch subpatch, GenericPatch genericPatch) {
        if (subpatch.getRebootRequired() != null && subpatch.getRebootRequired().trim().equalsIgnoreCase("true")) {
            genericPatch.setRebootRequired(true);
        }
    }

    public static void setMetadata(Subpatch subpatch, GenericPatch genericPatch) {
        BundleXmlUtilBase.setRebootRequired(subpatch, genericPatch);
        genericPatch.setScripts(subpatch.getScripts());
        genericPatch.setOs(subpatch.getOs());
        genericPatch.setAreRpmFilesPackaged(subpatch.getAreRpmFilesPackaged());
        genericPatch.setDestinationRepoLocation(subpatch.getDestRepoLocation());
        if (PatchingTool.NONOPATCH.toString().equals(genericPatch.getPatchTool())) {
            genericPatch.setPatchTool(subpatch.getPatchingTool().toString());
        }
    }

    public void print(SystemPatchBundleXML systemPatchBundleXML) {
        System.out.println(systemPatchBundleXML.toString());
        System.out.println(" UniquePatchID=" + systemPatchBundleXML.getUniquePatchID() + " PatchID=" + systemPatchBundleXML.getPatchID() + " BundleType=" + (Object)((Object)systemPatchBundleXML.getBundleType()) + " TypeVersion=" + systemPatchBundleXML.getTypeVersion() + " PatchAbstract=" + systemPatchBundleXML.getPatchAbstract());
        Automation automation2 = systemPatchBundleXML.getAutomation();
        System.out.println("   automation: OplanVersion=" + automation2.getOplanVersion() + " Hash=" + automation2.getHash());
        fvalue fvalue2 = systemPatchBundleXML.getFvalue();
        System.out.println("   fvalue: MinOpatchVersion" + fvalue2.getMinOpatchVersion() + " Function=" + fvalue2.getFunction() + " Value=" + fvalue2.getValue());
        System.out.println("   system:" + this.targetTypetoString(systemPatchBundleXML.getSystem()));
        System.out.println(this.scriptstoString(systemPatchBundleXML.getScripts()));
        System.out.println("   subpatches:");
        for (Subpatch subpatch : systemPatchBundleXML.getSubpatches()) {
            System.out.println(this.subpatchtoString(subpatch));
        }
    }

    public String scriptstoString(List<Script> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("Scripts: ");
        for (Script script : list) {
            stringBuffer.append(" Name= " + script.getName() + " Description= " + script.getDescription() + " Location= " + script.getLocation());
            if (script.getParams() != null) {
                for (Pair pair : script.getParams()) {
                    stringBuffer.append(" Param name= " + pair.getName() + " Param type= " + pair.getType());
                }
            }
            if (script.getTargetTypes() == null) continue;
            for (TargetType targetType : script.getTargetTypes()) {
                stringBuffer.append(this.targetTypetoString(targetType));
            }
        }
        return stringBuffer.toString();
    }

    public String targetTypetoString(TargetType targetType) {
        StringBuffer stringBuffer = new StringBuffer("TargetType: type=").append((Object)targetType.getType()).append(" version=").append(targetType.getVersion()).append(" EM propery name=").append(targetType.getPropertyName()).append(" EM property value=").append(targetType.getPropertyValue()).append(this.productToString(targetType.getProduct())).append(this.releaseToString(targetType.getRelease()));
        if (targetType instanceof SystemTargetType) {
            stringBuffer.append(" urm_component_id = ").append(((SystemTargetType)targetType).getUrmComponentId());
        }
        return stringBuffer.toString();
    }

    public String productToString(Product product) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Product").append(" name= ").append(product.getName()).append(" ARU ID= ").append(product.getAruID()).append(" QPart ID= ").append(product.getQpartID());
        return stringBuffer.toString();
    }

    public String releaseToString(Release release) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Release").append(" name= ").append(release.getName()).append(" ARU ID= ").append(release.getAruID()).append(" URM ID= ").append(release.getUrmID());
        return stringBuffer.toString();
    }

    public String subpatchtoString(Subpatch subpatch) {
        StringBuffer stringBuffer = new StringBuffer("subpatch: Location=").append(subpatch.getLocation()).append(" patchID=").append(subpatch.getPatchID()).append(" PatchingTool=").append((Object)subpatch.getPatchingTool()).append(" PatchType=").append((Object)subpatch.getPatchType()).append(" Platform=").append(subpatch.getPlatform()).append(" Are rpm files packaged =").append(subpatch.getAreRpmFilesPackaged()).append(" getDestRepoLocation=").append(subpatch.getDestRepoLocation());
        Release release = subpatch.getReleaseAfterPatching();
        if (release != null) {
            System.out.println("   releaseAfterPatching=" + release.toString());
        }
        if (subpatch.getTargetTypes() != null) {
            for (TargetType object : subpatch.getTargetTypes()) {
                stringBuffer.append("\n   ").append(this.targetTypetoString(object));
            }
        }
        if (subpatch.getChannels() != null) {
            for (Channel channel : subpatch.getChannels()) {
                stringBuffer.append("\n   ").append(this.channelToString(channel));
            }
        }
        if (subpatch.getRpmFiles() != null) {
            for (RpmFile rpmFile : subpatch.getRpmFiles()) {
                stringBuffer.append("\n   ").append(this.rpmFiletoString(rpmFile));
            }
        }
        if (subpatch.getScripts() != null) {
            stringBuffer.append("\n   ").append(this.scriptstoString(subpatch.getScripts()));
        }
        if (subpatch.getOs() != null) {
            stringBuffer.append("\n   ").append(this.OStoString(subpatch.getOs()));
        }
        return stringBuffer.toString();
    }

    public String OStoString(OS oS) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" OS ").append(" name= ").append(oS.getName()).append(" version= ").append(oS.getVersion()).append(" platform= ").append(oS.getPlatform());
        return stringBuffer.toString();
    }

    public String channelToString(Channel channel) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = channel.getIsOptional() == null ? "" : channel.getIsOptional().toString();
        stringBuffer.append(" Channel ").append(" name= ").append(channel.getName()).append(" is optional= ").append(string);
        if (channel.getAdvisories() != null) {
            stringBuffer.append(" Avisories:");
            for (Advisory object : channel.getAdvisories()) {
                stringBuffer.append(object.toString());
            }
        }
        if (channel.getExclusionList() != null) {
            stringBuffer.append("  exclusion list:");
            for (String string2 : channel.getExclusionList()) {
                stringBuffer.append(string2.toString());
            }
        }
        return stringBuffer.toString();
    }

    public String rpmFiletoString(RpmFile rpmFile) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" RpmFile ").append(" name= ").append(rpmFile.getName()).append(" is optional= ").append(rpmFile.getIsOptional() == null ? " null " : rpmFile.getIsOptional().toString()).append(rpmFile.getAction() == null ? " no action " : " action=" + rpmFile.getAction().toString()).append(rpmFile.getSourceChannel() == null ? "no source channel" : " source channel=" + rpmFile.getSourceChannel().toString());
        return stringBuffer.toString();
    }
}

