/*
 * Decompiled with CFR 0.152.
 */
package model.util;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import model.bundle_xml.SystemPatchBundleXML;
import model.bundle_xml.TargetTypeOrder;
import model.patchmodel.DeployTargetOrder;
import model.patchmodel.EngineeredSystemPatch;
import model.util.BundleXmlUtilBase;
import org.xml.sax.SAXException;

public class BundleXmlUtil
extends BundleXmlUtilBase {
    public BundleXmlUtil() throws JAXBException, SAXException {
        logger = Logger.getLogger(this.getClass().getName());
        this.creatUnmarshaller();
    }

    private void creatUnmarshaller() throws JAXBException, SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(this.getClass().getResource("/" + xsdFileName));
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])this.getClasses());
        this.unmarshaller = jAXBContext.createUnmarshaller();
        this.unmarshaller.setSchema(schema);
    }

    public SystemPatchBundleXML readBundle(File file) throws JAXBException, SAXException {
        if (file == null) {
            throw new RuntimeException("xml file is null!");
        }
        xmlFileName = file.getAbsolutePath() + file.getName();
        return (SystemPatchBundleXML)this.unmarshaller.unmarshal(file);
    }

    public SystemPatchBundleXML readBundle(String string) throws JAXBException, SAXException {
        return (SystemPatchBundleXML)this.unmarshaller.unmarshal((Reader)new StringReader(string));
    }

    public SystemPatchBundleXML readBundle(InputStream inputStream) throws JAXBException, SAXException {
        return (SystemPatchBundleXML)this.unmarshaller.unmarshal(inputStream);
    }

    public static void populateDelpoyOrder(SystemPatchBundleXML systemPatchBundleXML, EngineeredSystemPatch engineeredSystemPatch) {
        List<TargetTypeOrder> list;
        if (systemPatchBundleXML.getIsDeployOrderRequired() != null && systemPatchBundleXML.getIsDeployOrderRequired().trim().equalsIgnoreCase("true")) {
            engineeredSystemPatch.setIsDeployOrderRequired(true);
        }
        if ((list = systemPatchBundleXML.getDeployorder()) != null && !list.isEmpty()) {
            ArrayList<DeployTargetOrder> arrayList = new ArrayList<DeployTargetOrder>();
            engineeredSystemPatch.setDeployOrder(arrayList);
            for (TargetTypeOrder targetTypeOrder : list) {
                DeployTargetOrder deployTargetOrder = new DeployTargetOrder();
                arrayList.add(deployTargetOrder);
                deployTargetOrder.setTargetType(targetTypeOrder.getType());
                deployTargetOrder.setVersion(targetTypeOrder.getVersion());
                deployTargetOrder.setOrder(targetTypeOrder.getOrder());
                deployTargetOrder.setPropertyName(targetTypeOrder.getPropertyName());
                deployTargetOrder.setPropertyValue(targetTypeOrder.getPropertyValue());
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            BundleXmlUtil bundleXmlUtil = new BundleXmlUtil();
            SystemPatchBundleXML systemPatchBundleXML = bundleXmlUtil.readBundle(new File(xmlFileName));
            System.out.println("\n**********  BundleXmlUtil TESTING System Patch bundle xml V2: newly generated XSD (model/xml) with old test v2 XML  **************");
            bundleXmlUtil.print(systemPatchBundleXML);
            System.out.println("**********************************************************\n");
        }
        catch (Throwable throwable) {
            System.out.println(" Exception = " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }
}

