/*
 * Decompiled with CFR 0.152.
 */
package model.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import model.bundle_xml.SystemPatchBundleXML;
import model.util.BundleValidationException;
import model.util.BundleXmlException;
import model.util.BundleXmlUtilBase;
import org.xml.sax.SAXException;

public class BundleXmlHelper
extends BundleXmlUtilBase {
    public BundleXmlHelper() throws BundleXmlException {
        logger = Logger.getLogger(this.getClass().getName());
        this.creatUnmarshaller();
    }

    private void creatUnmarshaller() throws BundleXmlException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(this.getClass().getResource("/" + xsdFileName));
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])this.getClasses());
            this.unmarshaller = jAXBContext.createUnmarshaller();
            this.unmarshaller.setSchema(schema);
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context due to: " + BundleXmlHelper.digoutMessage(jAXBException);
            logger.log(Level.SEVERE, string);
            throw new BundleXmlException(string, jAXBException);
        }
        catch (SAXException sAXException) {
            String string = "The Bundle schema is invalid: " + BundleXmlHelper.digoutMessage(sAXException);
            logger.log(Level.SEVERE, string);
            throw new BundleXmlException(string, sAXException);
        }
    }

    public SystemPatchBundleXML readBundle(File file) throws BundleXmlException, BundleValidationException {
        if (file == null) {
            throw new BundleXmlException("xml file is null!");
        }
        xmlFileName = file.getAbsolutePath();
        try {
            return (SystemPatchBundleXML)this.unmarshaller.unmarshal((InputStream)new FileInputStream(xmlFileName));
        }
        catch (UnmarshalException unmarshalException) {
            String string = xmlFileName + " is not valid: " + BundleXmlHelper.digoutMessage(unmarshalException) + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, string);
            throw new BundleValidationException(string, unmarshalException);
        }
        catch (JAXBException jAXBException) {
            String string = "Unexpected error " + BundleXmlHelper.digoutMessage(jAXBException) + " occured while unmarshalling " + xmlFileName;
            logger.log(Level.SEVERE, string);
            throw new BundleXmlException(string, jAXBException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = xmlFileName + " is not valid: " + BundleXmlHelper.digoutMessage(fileNotFoundException) + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, string);
            throw new BundleValidationException(string, fileNotFoundException);
        }
    }

    public SystemPatchBundleXML readBundle(String string) throws BundleValidationException, BundleXmlException {
        try {
            return (SystemPatchBundleXML)this.unmarshaller.unmarshal((Reader)new StringReader(string));
        }
        catch (UnmarshalException unmarshalException) {
            String string2 = " bundle.xml is not valid:" + BundleXmlHelper.digoutMessage(unmarshalException) + ". xml is " + string + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, string2);
            throw new BundleValidationException(string2, unmarshalException);
        }
        catch (JAXBException jAXBException) {
            String string3 = "Unexpected error " + BundleXmlHelper.digoutMessage(jAXBException) + " occured while unmarshalling bundle.xml: " + string;
            logger.log(Level.SEVERE, string3);
            throw new BundleXmlException(string3, jAXBException);
        }
    }

    public SystemPatchBundleXML readBundle(InputStream inputStream) throws BundleValidationException, BundleXmlException {
        try {
            return (SystemPatchBundleXML)this.unmarshaller.unmarshal(inputStream);
        }
        catch (UnmarshalException unmarshalException) {
            String string = " bundle.xml is not valid:" + BundleXmlHelper.digoutMessage(unmarshalException) + ". xml is " + inputStream + " Schema is " + xsdFileName;
            logger.log(Level.SEVERE, string);
            throw new BundleValidationException(string, unmarshalException);
        }
        catch (JAXBException jAXBException) {
            String string = "Unexpected error " + BundleXmlHelper.digoutMessage(jAXBException) + " occured while unmarshalling bundle.xml: " + inputStream;
            logger.log(Level.SEVERE, string);
            throw new BundleXmlException(string, jAXBException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            BundleXmlHelper bundleXmlHelper = new BundleXmlHelper();
            SystemPatchBundleXML systemPatchBundleXML = bundleXmlHelper.readBundle(new File(xmlFileName));
            System.out.println("\n**********  BundleXmlHelper: TESTING System Patch bundle xml: newly generated XSD (model/xml) with old test XML  **************");
            bundleXmlHelper.print(systemPatchBundleXML);
            System.out.println("**********************************************************\n");
            System.out.println("\n**********  BundleXmlHelper: TESTING System Patch bundle V3 xml: newly generated XSD (model/xml) with old test v3 XML  **************");
            SystemPatchBundleXML systemPatchBundleXML2 = bundleXmlHelper.readBundle(new File(xmlV3FileName));
            bundleXmlHelper.print(systemPatchBundleXML2);
            System.out.println("**********************************************************\n");
        }
        catch (Throwable throwable) {
            System.out.println(" Exception = " + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    static String digoutMessage(Throwable throwable) {
        if (throwable.getMessage() != null && throwable.getMessage().trim().length() != 0) {
            return throwable.getMessage();
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            return null;
        }
        return BundleXmlHelper.digoutMessage(throwable2);
    }
}

