/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.BaseClass;
import model.bundle_xml.TargetType;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInstance {
    private final Logger logger = Logger.getLogger(BaseClass.class.getName());
    protected List<BaseClass> systemEntities = new ArrayList<BaseClass>();
    private AbstractBaseTarget top = null;

    public List<BaseClass> getEntities() {
        return this.systemEntities;
    }

    public SystemInstance(List<BaseClass> list, AbstractBaseTarget abstractBaseTarget) {
        this.top = abstractBaseTarget;
        this.systemEntities = list;
    }

    public SystemInstance() {
    }

    public void writeFile(File file) throws FileNotFoundException {
        XMLEncoder xMLEncoder = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(file)));
        xMLEncoder.writeObject(this.getEntities());
        xMLEncoder.close();
    }

    public SystemInstance readFile(File file) throws FileNotFoundException {
        XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(file)));
        SystemInstance systemInstance = new SystemInstance();
        ArrayList arrayList = (ArrayList)xMLDecoder.readObject();
        for (Object e : arrayList) {
            systemInstance.getEntities().add((BaseClass)e);
        }
        return systemInstance;
    }

    public AbstractBaseTarget getTop() {
        return this.top;
    }

    public AbstractBaseTarget setTop(AbstractBaseTarget abstractBaseTarget) {
        AbstractBaseTarget abstractBaseTarget2 = this.top;
        this.top = abstractBaseTarget;
        return abstractBaseTarget2;
    }

    public void add(BaseClass baseClass) {
        this.systemEntities.add(baseClass);
    }

    public <T extends AbstractBaseTarget> List<T> getTargetsOfType(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        this.logger.fine("Filtering for class: " + clazz);
        for (BaseClass baseClass : this.getEntities()) {
            if (!clazz.isInstance(baseClass)) continue;
            arrayList.add(clazz.cast(baseClass));
        }
        this.logger.fine("Found and returning: " + arrayList);
        return arrayList;
    }

    public List<AbstractBaseTarget> getTargetsOfEMTypeAndVersion(TargetType targetType) {
        ArrayList<AbstractBaseTarget> arrayList = new ArrayList<AbstractBaseTarget>();
        if (targetType.getType() == null) {
            throw new IllegalArgumentException(" type is missing in subpatch target type metadata");
        }
        if (targetType.getType() == null) {
            throw new IllegalArgumentException(" type ID is missing in subpatch target type metadata");
        }
        String string = targetType.getType().toString().trim();
        String string2 = targetType.getVersion();
        String string3 = targetType.getPropertyName();
        String string4 = targetType.getPropertyValue();
        for (BaseClass baseClass : this.getEntities()) {
            String string5;
            AbstractBaseTarget abstractBaseTarget = null;
            if (baseClass instanceof AbstractBaseTarget) {
                abstractBaseTarget = (AbstractBaseTarget)baseClass;
            }
            if (abstractBaseTarget == null || (string5 = abstractBaseTarget.getTargetTypeId()) == null || string5.trim().length() == 0) continue;
            string5 = string5.trim();
            String string6 = abstractBaseTarget.getVersion();
            if (string6 != null) {
                string6 = string6.trim();
            }
            if (!string.equals(string5) || string2 != null && !string2.trim().equals(string6)) continue;
            if (string3 == null || string3.trim().length() == 0) {
                arrayList.add(abstractBaseTarget);
                continue;
            }
            if (string4 == null || string4.trim().length() == 0) continue;
            String string7 = abstractBaseTarget.getEMpropertyName();
            String string8 = abstractBaseTarget.getEMpropertyValue();
            if (string7 == null || string7.trim().length() == 0 || string8 == null || string8.trim().length() == 0 || !string7.trim().equals(string3.trim()) || !string8.trim().equals(string4.trim())) continue;
            arrayList.add(abstractBaseTarget);
        }
        return arrayList;
    }

    public List<OracleHome> getAllHomes() {
        ArrayList<OracleHome> arrayList = new ArrayList<OracleHome>();
        for (BaseClass baseClass : this.getEntities()) {
            if (!(baseClass instanceof OracleHome)) continue;
            arrayList.add((OracleHome)baseClass);
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(" SystemInstance: top=").append(this.getTop() != null ? this.getTop().toString() : "null");
        for (BaseClass baseClass : this.getEntities()) {
            if (!(baseClass instanceof AbstractBaseTarget)) continue;
            AbstractBaseTarget abstractBaseTarget = (AbstractBaseTarget)baseClass;
            stringBuffer.append("\n").append(baseClass.toString()).append(" version=").append(abstractBaseTarget.getVersion()).append(" targetTypeId=").append(abstractBaseTarget.getTargetTypeId()).append(" EM property name=").append(abstractBaseTarget.getEMpropertyName()).append(" EM property Value=").append(abstractBaseTarget.getEMpropertyValue());
        }
        return stringBuffer.toString();
    }
}

