/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlID;
import model.AssociationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseClass {
    private static Logger logger = Logger.getLogger(BaseClass.class.getName());
    private final String id = UUID.randomUUID().toString();
    private final String uid = UUID.randomUUID().toString();
    private String GUID;
    protected String targetTypeId = null;
    private static Map declaredMethods = null;
    protected String name = null;
    HashMap<Class, Object> map = new HashMap();

    public String getId() {
        return this.id;
    }

    @XmlID
    public String getUId() {
        return this.getLeafClassName() + "-" + this.uid;
    }

    public String getUniqueId() {
        return this.getLeafClassName() + "-" + this.getId();
    }

    public String getTargetTypeId() {
        return this.targetTypeId;
    }

    public String getGUID() {
        return this.GUID;
    }

    public void setGUID(String string) {
        this.GUID = string;
    }

    public static boolean isDeclaredOnBaseClass(Method method) {
        if (declaredMethods == null) {
            declaredMethods = new HashMap();
            for (Method method2 : BaseClass.class.getDeclaredMethods()) {
                declaredMethods.put(method2, null);
            }
            for (Method method2 : Object.class.getDeclaredMethods()) {
                declaredMethods.put(method2, null);
            }
        }
        return declaredMethods.containsKey(method);
    }

    public static boolean isOnBaseClass(Method method) {
        if (declaredMethods == null) {
            declaredMethods = new HashMap();
            for (Method method2 : BaseClass.class.getMethods()) {
                declaredMethods.put(method2, null);
            }
        }
        return declaredMethods.containsKey(method);
    }

    private Map<String, Object> gatherAttributes() throws IllegalArgumentException, IllegalAccessException {
        Class<Object> clazz = this.getClass();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (!clazz.equals(BaseClass.class)) {
            Map<String, Object> map = this.gatherAttributes(clazz);
            for (String string : map.keySet()) {
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, map.get(string));
            }
            clazz = clazz.getSuperclass().asSubclass(BaseClass.class);
        }
        return hashMap;
    }

    private Map<String, Object> gatherAttributes(Class clazz) throws IllegalArgumentException, IllegalAccessException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Field field : clazz.getDeclaredFields()) {
            if (List.class.isAssignableFrom(field.getType()) || BaseClass.class.isAssignableFrom(field.getType())) continue;
            String string = field.getName();
            field.setAccessible(true);
            hashMap.put(string, field.get(this));
        }
        return hashMap;
    }

    public Map<String, List<BaseClass>> getOutboundAssociations() {
        String string = "Failed to retrive objects associated to" + this.toString();
        try {
            return this.getAssociatedObjects();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            throw new RuntimeException(string, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            throw new RuntimeException(string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, invocationTargetException);
            throw new RuntimeException(string, invocationTargetException);
        }
    }

    public Map<String, List<BaseClass>> getAssociatedObjects() throws IllegalAccessException, InvocationTargetException {
        HashMap<String, List<BaseClass>> hashMap = new HashMap<String, List<BaseClass>>();
        Class<?> clazz = this.getClass();
        for (Method method : clazz.getMethods()) {
            boolean bl;
            Object object;
            if (BaseClass.isDeclaredOnBaseClass(method)) continue;
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            if (!string.startsWith("get") || classArray.length != 0 || (object = method.invoke((Object)this, null)) == null || object instanceof List && ((List)object).isEmpty()) continue;
            boolean bl2 = bl = object instanceof BaseClass || object instanceof List && ((List)object).get(0) instanceof BaseClass;
            if (!bl) continue;
            ArrayList<BaseClass> arrayList = new ArrayList<BaseClass>();
            if (object instanceof List) {
                for (Object e : (List)object) {
                    arrayList.add((BaseClass)e);
                }
            } else {
                arrayList.add((BaseClass)object);
            }
            hashMap.put(string, arrayList);
        }
        return hashMap;
    }

    public String getLeafClassName() {
        return this.getClass().getSimpleName();
    }

    public Map<String, Object> getAttributes() {
        try {
            return this.gatherAttributes();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, illegalArgumentException);
            throw new RuntimeException(null, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            throw new RuntimeException(null, illegalAccessException);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + (this.name() != null ? "-" + this.name : "");
    }

    public String name() {
        if (this.name != null) {
            return this.name;
        }
        try {
            Method method = this.getClass().getMethod("getName", null);
            if (method != null) {
                this.name = (String)method.invoke((Object)this, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.name;
    }

    public String print() {
        StringBuffer stringBuffer = new StringBuffer("**********" + this.getClass().getName() + "-" + this.getGUID() + "**********");
        Class<?> clazz = this.getClass();
        while (!clazz.getName().contains("BaseClass")) {
            this.appendDeclared(stringBuffer, clazz, this);
            clazz = clazz.getSuperclass();
        }
        stringBuffer.append("\n*******************************");
        return stringBuffer.toString();
    }

    public String print(Object object) {
        Class<?> clazz = object.getClass();
        StringBuffer stringBuffer = new StringBuffer("***" + clazz.getName() + "-" + ((BaseClass)object).getGUID() + "***");
        while (!clazz.getName().contains("BaseClass")) {
            this.appendDeclared(stringBuffer, clazz, object);
            clazz = clazz.getSuperclass();
        }
        stringBuffer.append("\n*******");
        return stringBuffer.toString();
    }

    public void appendDeclared(StringBuffer stringBuffer, Class clazz, Object object) {
        for (Field field : clazz.getDeclaredFields()) {
            if (List.class.isAssignableFrom(field.getType()) || BaseClass.class.isAssignableFrom(field.getType())) continue;
            Annotation[] annotationArray = field.getName();
            field.setAccessible(true);
            Object object2 = null;
            try {
                object2 = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
            if (object2 == null) continue;
            stringBuffer.append("\n" + (String)annotationArray + "=" + object2);
        }
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (annotation == null || !annotation.annotationType().equals(AssociationType.class)) continue;
                AssociationType associationType = (AssociationType)annotation;
                field.setAccessible(true);
                BaseClass baseClass = null;
                if (associationType.value().equals((Object)AssociationType.EnumType.MOUNTED_ON)) {
                    stringBuffer.append("\n" + (Object)((Object)associationType.value()) + " ");
                    try {
                        if (field.get(object) == null) {
                            stringBuffer.append(" not set");
                            continue;
                        }
                        for (Object e : (List)field.get(object)) {
                            baseClass = (BaseClass)e;
                            stringBuffer.append(baseClass.print(baseClass));
                        }
                        continue;
                    }
                    catch (Throwable throwable) {
                        Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, throwable);
                        continue;
                    }
                }
                if (!associationType.value().equals((Object)AssociationType.EnumType.HOSTED_BY) && !associationType.value().equals((Object)AssociationType.EnumType.RUNS_FROM)) continue;
                stringBuffer.append("\n" + (Object)((Object)associationType.value()) + " ");
                try {
                    baseClass = (BaseClass)field.get(object);
                }
                catch (Throwable throwable) {
                    Logger.getLogger(BaseClass.class.getName()).log(Level.SEVERE, null, throwable);
                }
                if (baseClass == null) {
                    stringBuffer.append(" not set");
                    continue;
                }
                stringBuffer.append(baseClass.print(baseClass));
            }
        }
    }

    public Method getSetter(Method method) {
        String string = method.getName();
        string = "s" + string.substring(1);
        Class[] classArray = new Class[]{method.getReturnType()};
        try {
            return this.getClass().getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public Method getGetter(Method method) {
        String string = method.getName();
        string = "g" + string.substring(1);
        try {
            return this.getClass().getMethod(string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.severe("\n NoSuchMethodException: " + this.getClass().getName() + "." + string + "( null )");
            return null;
        }
    }

    public List<Method> getRequestedAttributeGetters() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Class<?> clazz = this.getClass();
        for (Method method : clazz.getMethods()) {
            boolean bl;
            if (BaseClass.isDeclaredOnBaseClass(method)) continue;
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            if (!string.startsWith("get") || classArray.length != 0) continue;
            Object object = null;
            try {
                object = method.invoke((Object)this, null);
            }
            catch (Exception exception) {
                continue;
            }
            if (object == null || object instanceof List && ((List)object).isEmpty()) continue;
            boolean bl2 = bl = object instanceof BaseClass || object instanceof List && ((List)object).get(0) instanceof BaseClass;
            if (bl) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    public Map<Method, List<BaseClass>> getRequestedAssociationGetters() {
        HashMap<Method, List<BaseClass>> hashMap = new HashMap<Method, List<BaseClass>>();
        Class<?> clazz = this.getClass();
        for (Method method : clazz.getMethods()) {
            boolean bl;
            if (BaseClass.isDeclaredOnBaseClass(method)) continue;
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            if (!string.startsWith("get") || classArray.length != 0) continue;
            Object object = null;
            try {
                object = method.invoke((Object)this, null);
            }
            catch (Exception exception) {
                continue;
            }
            if (object == null || object instanceof List && ((List)object).isEmpty()) continue;
            boolean bl2 = bl = object instanceof BaseClass || object instanceof List && ((List)object).get(0) instanceof BaseClass;
            if (!bl) continue;
            ArrayList<BaseClass> arrayList = new ArrayList<BaseClass>();
            if (object instanceof List) {
                for (Object e : (List)object) {
                    arrayList.add((BaseClass)e);
                }
            } else {
                arrayList.add((BaseClass)object);
            }
            hashMap.put(this.getSetter(method), arrayList);
        }
        return hashMap;
    }

    public List<Method> getRequestedGetters() {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Class<?> clazz = this.getClass();
        for (Method method : clazz.getMethods()) {
            if (BaseClass.isOnBaseClass(method)) continue;
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            if (!string.startsWith("get") || classArray.length != 0) continue;
            Object object = null;
            try {
                object = method.invoke((Object)this, null);
            }
            catch (Exception exception) {
                continue;
            }
            if (object == null) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    public void removeDefaultValues() {
        Class<?> clazz = this.getClass();
        for (Method method : clazz.getMethods()) {
            if (BaseClass.isOnBaseClass(method)) continue;
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            if (!string.startsWith("get") || classArray.length != 0) continue;
            Object object = null;
            try {
                object = method.invoke((Object)this, null);
            }
            catch (Exception exception) {
                continue;
            }
            if (object == null) continue;
            Method method2 = this.getSetter(method);
            try {
                Class<?> clazz2;
                if (method2 == null || (clazz2 = method.getReturnType()).equals(Boolean.class) || clazz2.equals(Boolean.TYPE)) continue;
                object = method2.invoke((Object)this, clazz2.cast(null));
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "While calling setter:" + method2, exception);
            }
        }
    }

    public static String getInverseAssociationType(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equals("HOST_FOR")) {
            return "HOSTED_BY";
        }
        if (string.equals("HOSTED_BY")) {
            return "HOST_FOR";
        }
        if (string.equals("CLUSTER_MEMBER")) {
            return "CONTAINS";
        }
        if (string.equals("CONTAINS")) {
            return "CLUSTER_MEMBER";
        }
        return null;
    }

    public <P> P getProperty(Class<P> clazz) {
        return (P)this.map.get(clazz);
    }

    public <P> void setProperty(Class<P> clazz, P p) {
        this.map.put(clazz, p);
    }

    public <P> void setProperty(P p) {
        this.map.put(p.getClass(), p);
    }
}

