/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.x509;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.x509.X509BinarySecurityToken;
import oracle.security.xmlsec.wss.x509.X509KeyIdentifierResolver;
import oracle.security.xmlsec.wss.x509.X509KeyIdentifierResolverException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509KeyIdentifier
extends WSSKeyIdentifier {
    public static final String vt_x509PKI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    protected static final String DEFAULT_ENCODING_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    private static ArrayList resolverList = new ArrayList();

    public static void addResolver(X509KeyIdentifierResolver resolver) {
        resolverList.add(resolver);
    }

    public static List getResolvers() {
        return resolverList;
    }

    public X509KeyIdentifier(Element element) {
        super(element);
    }

    public X509KeyIdentifier(Element element, String systemId) {
        super(element, systemId);
    }

    public X509KeyIdentifier(Document owner) {
        super(owner, vt_x509PKI, DEFAULT_ENCODING_TYPE);
    }

    public X509KeyIdentifier(Document owner, String valType) {
        super(owner, valType);
    }

    public X509KeyIdentifier(Document owner, String valType, String encType) {
        super(owner, valType, encType);
    }

    @Override
    public WSSecurityToken getSecurityToken() throws WSSException {
        X509Certificate cert = null;
        int n = resolverList.size();
        for (int i = 0; i < n && cert == null; ++i) {
            X509KeyIdentifierResolver r = (X509KeyIdentifierResolver)resolverList.get(i);
            try {
                cert = r.resolve(this, this.getValueType());
                continue;
            }
            catch (X509KeyIdentifierResolverException ex) {
                cert = null;
            }
        }
        if (cert == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        X509BinarySecurityToken x509Token = new X509BinarySecurityToken(this.getOwnerDocument());
        x509Token.setToken(cert);
        x509Token.removeAttribute("EncodingType");
        x509Token.alreadyValidated = true;
        return x509Token;
    }

    @Override
    public Object getKey() throws WSSException {
        PrivateKey key = null;
        if (key == null) {
            int n = resolverList.size();
            for (int i = 0; i < n && key == null; ++i) {
                X509KeyIdentifierResolver r = (X509KeyIdentifierResolver)resolverList.get(i);
                try {
                    key = r.getPrivateKey(this, this.getValueType());
                    continue;
                }
                catch (X509KeyIdentifierResolverException ex) {
                    key = null;
                }
            }
        }
        if (key == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        return key;
    }

    @Override
    protected String getDefaultEncodingType() {
        return DEFAULT_ENCODING_TYPE;
    }

    @Override
    public byte[] getThumbprint() {
        return this.getValueType().equals("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1") ? this.getValue() : null;
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.getValueType().equals(vt_x509PKI) ? this.getValue() : null;
    }

    public boolean matches(X509Certificate cert) {
        byte[] ext;
        byte[] SKI = this.getSubjectKeyIdentifier();
        if (SKI != null && (ext = XMLUtils.getSKI((X509Certificate)cert)) != null && Arrays.equals(ext, SKI)) {
            return true;
        }
        byte[] SHA1 = this.getThumbprint();
        if (SHA1 != null) {
            try {
                MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
                byte[] sha1 = sha1Digester.digest(cert.getEncoded());
                if (Arrays.equals(sha1, SHA1)) {
                    return true;
                }
            }
            catch (CertificateEncodingException e) {
                IllegalArgumentException ex1 = new IllegalArgumentException("Can't encode certificate");
                ex1.initCause(e);
                throw ex1;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return false;
    }
}

