/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.util;

import java.security.Security;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSBinarySecurityToken;
import oracle.security.xmlsec.wss.WSSEmbedded;
import oracle.security.xmlsec.wss.WSSEncryptedHeader;
import oracle.security.xmlsec.wss.WSSEncryptedKeyIdentifier;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSReference;
import oracle.security.xmlsec.wss.WSSecurity;
import oracle.security.xmlsec.wss.WSSecurityTokenReference;
import oracle.security.xmlsec.wss.WSSignatureConfirmation;
import oracle.security.xmlsec.wss.WSUCreated;
import oracle.security.xmlsec.wss.WSUExpires;
import oracle.security.xmlsec.wss.WSUTimestamp;
import oracle.security.xmlsec.wss.encoding.Base64BinaryEncoder;
import oracle.security.xmlsec.wss.encoding.HexBinaryEncoder;
import oracle.security.xmlsec.wss.encoding.XSDDateTimeEncoder;
import oracle.security.xmlsec.wss.kerberos.KerberosBinarySecurityToken;
import oracle.security.xmlsec.wss.kerberos.KerberosKeyIdentifier;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifier;
import oracle.security.xmlsec.wss.saml.SAMLAssertionToken;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifier;
import oracle.security.xmlsec.wss.swa.SWAUtil;
import oracle.security.xmlsec.wss.transform.AttachmentCiphertextTransform;
import oracle.security.xmlsec.wss.transform.AttachmentCompleteSignatureTransform;
import oracle.security.xmlsec.wss.transform.AttachmentContentSignatureTransform;
import oracle.security.xmlsec.wss.transform.STRTransform;
import oracle.security.xmlsec.wss.transform.StreamingSTRTransform;
import oracle.security.xmlsec.wss.username.UsernameToken;
import oracle.security.xmlsec.wss.util.WSSKeyRetriever;
import oracle.security.xmlsec.wss.util.WSSTransformsProvider;
import oracle.security.xmlsec.wss.wsc.WSCDerivedKeyToken;
import oracle.security.xmlsec.wss.wsc.WSCSecurityContextToken;
import oracle.security.xmlsec.wss.x509.X509BinarySecurityToken;
import oracle.security.xmlsec.wss.x509.X509IssuerSerial;
import oracle.security.xmlsec.wss.x509.X509KeyIdentifier;

public class WSSInitializer {
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            XMLElement.setDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", (String)"wsse");
            XMLElement.setDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"wsu");
            XMLElement.setDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", (String)"wsse11");
            XMLElement.setDefaultNSPrefix((String)"http://schemas.xmlsoap.org/ws/2005/02/sc", (String)"wsc");
            XMLElement.setDefaultNSPrefix((String)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", (String)"wsc13");
            TagManager m = TagManager.getTagManager();
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created", WSUCreated.class);
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires", WSUExpires.class);
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp", WSUTimestamp.class);
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", WSSecurity.class);
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken", UsernameToken.class);
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken", WSSBinarySecurityToken.class);
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference", WSSecurityTokenReference.class);
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference", WSSReference.class);
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier", WSSKeyIdentifier.class);
            m.mapTag("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Embedded", WSSEmbedded.class);
            m.mapTag("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "EncryptedHeader", WSSEncryptedHeader.class);
            m.mapTag("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "SignatureConfirmation", WSSignatureConfirmation.class);
            m.mapTag("http://schemas.xmlsoap.org/ws/2005/02/sc", "DerivedKeyToken", WSCDerivedKeyToken.WSCDerivedKeyToken12.class);
            m.mapTag("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "DerivedKeyToken", WSCDerivedKeyToken.WSCDerivedKeyToken13.class);
            m.mapTag("http://schemas.xmlsoap.org/ws/2005/02/sc", "SecurityContextToken", WSCSecurityContextToken.WSCSecurityContextToken12.class);
            m.mapTag("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "SecurityContextToken", WSCSecurityContextToken.WSCSecurityContextToken13.class);
            m.mapTag("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial", X509IssuerSerial.class);
            URIManager u = URIManager.getURIManager();
            if (System.getProperty("osdt.useOldC14n") != null) {
                u.mapClass("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "transformer", STRTransform.class);
            } else {
                u.mapClass("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "transformer", StreamingSTRTransform.class);
            }
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform", "transformer", AttachmentCiphertextTransform.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete-Signature-Transform", "transformer", AttachmentCompleteSignatureTransform.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform", "transformer", AttachmentContentSignatureTransform.class);
            u.mapClass("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1", "useBinaryToken", X509BinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", "useBinaryToken", X509BinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1", "useBinaryToken", X509BinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7", "useBinaryToken", X509BinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ", "useBinaryToken", KerberosBinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ1510", "useBinaryToken", KerberosBinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ4120", "useBinaryToken", KerberosBinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ", "useBinaryToken", KerberosBinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ1510", "useBinaryToken", KerberosBinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ4120", "useBinaryToken", KerberosBinarySecurityToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier", "useIdentifier", X509KeyIdentifier.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID", "useIdentifier", SAMLAssertionKeyIdentifier.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID", "useIdentifier", SAML2AssertionKeyIdentifier.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1", "useIdentifier", KerberosKeyIdentifier.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1", "useIdentifier", WSSEncryptedKeyIdentifier.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1", "useIdentifier", WSSKeyIdentifier.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5_AP_REQ", "useIdentifier", KerberosKeyIdentifier.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertion-1.0", "useReference", SAMLAssertionToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertion-1.1", "useReference", SAMLAssertionToken.class);
            u.mapClass("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary", "useBinaryEncoder", Base64BinaryEncoder.class);
            u.mapClass("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#HexBinary", "useBinaryEncoder", HexBinaryEncoder.class);
            u.mapClass("http://www.w3.org/2001/XMLSchema/dateTime", "useDateEncoder", XSDDateTimeEncoder.class);
            XMLUtils.addIdAttribute((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Id");
            XMLUtils.addIdAttribute((String)"urn:oasis:names:tc:SAML:1.0:assertion", (String)"AssertionID");
            ObjectReference.setCIDResolver((ObjectReference.CIDResolver)new SWAUtil.SWACIDResolver());
            if (System.getProperty("osdt.useJSR105") != null) {
                Security.addProvider(new WSSTransformsProvider());
            }
            KeyRetriever.addKeyRetriever((KeyRetriever)new WSSKeyRetriever());
            initialized = true;
        }
    }

    private WSSInitializer() {
    }
}

