/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.wss.swa.MimeHeaderC14N;
import oracle.security.xmlsec.wss.swa.SWAUtil;

public class AttachmentContentSignatureTransform
extends XSTransformer {
    protected boolean includeHeaders = false;

    public AttachmentContentSignatureTransform(XSAlgorithmIdentifier trans) throws IllegalArgumentException {
        super(trans);
    }

    public String getAlgorithmURI() {
        return "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform";
    }

    public XMLContainer transform(XMLContainer source) throws TransformationException {
        InputStream is;
        ContentType ct;
        AttachmentPart ap;
        try {
            ap = (AttachmentPart)source.getUserData();
            ct = new ContentType(ap.getContentType());
            is = SWAUtil.getInputStream(ap);
        }
        catch (ClassCastException ex) {
            throw new TransformationException("Expecting an AttachmentmentPart object", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            throw new TransformationException("Expecting an AttachmentmentPart object", (Throwable)ex);
        }
        catch (ParseException ex) {
            throw new TransformationException("Can't retrieve attachment content type", (Throwable)ex);
        }
        catch (SOAPException ex) {
            throw new TransformationException("Can't retrieve attachment input stream", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new TransformationException("Can't retrieve attachment input stream", (Throwable)ex);
        }
        byte[] headers = null;
        try {
            if (this.includeHeaders) {
                headers = MimeHeaderC14N.canonicalizeMimeHeaders(ap).getBytes("UTF8");
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new TransformationException("Can't transform mime headers", (Throwable)ex);
        }
        catch (AddressException ex) {
            throw new TransformationException("Can't transform mime headers", (Throwable)ex);
        }
        catch (ParseException ex) {
            throw new TransformationException("Can't transform mime headers", (Throwable)ex);
        }
        byte[] content = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            byte[] buf = new byte[8192];
            int n = is.read(buf);
            while (n != -1) {
                bos.write(buf, 0, n);
                n = is.read(buf);
            }
        }
        catch (IOException ex) {
            throw new TransformationException("Can't retrieve attachment input stream", (Throwable)ex);
        }
        content = bos.toByteArray();
        String b = ct.getBaseType();
        if (b.equals("text/xml") || b.equals("application/xml") || b.equals("text/xml-external-parsed-entity") || b.equals("application/xml-external-parsed-entity") || b.equals("application/xml-dtd") || ct.getSubType().endsWith("+xml")) {
            Canonicalizer c14n = Canonicalizer.getInstance((boolean)false, (boolean)false);
            content = c14n.canonicalize((InputStream)new ByteArrayInputStream(content));
        } else if (ct.getPrimaryType().equals("text")) {
            // empty if block
        }
        if (headers != null) {
            byte[] newContent = new byte[headers.length + content.length];
            System.arraycopy(headers, 0, newContent, 0, headers.length);
            System.arraycopy(content, 0, newContent, headers.length, content.length);
            content = newContent;
        }
        XMLContainer cont = null;
        try {
            cont = new XMLContainer(content);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cont;
    }
}

