/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.saml2;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.saml2.core.Assertion;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifierResolver;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifierResolverException;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionToken;
import oracle.security.xmlsec.wss.util.WSSTokenUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2AssertionKeyIdentifier
extends WSSKeyIdentifier {
    private static ArrayList resolverList = new ArrayList();

    public static void addResolver(SAML2AssertionKeyIdentifierResolver resolver) {
        resolverList.add(resolver);
    }

    public static List getResolvers() {
        return resolverList;
    }

    public SAML2AssertionKeyIdentifier(Element element) {
        super(element);
        this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
    }

    public SAML2AssertionKeyIdentifier(Element element, String systemId) {
        super(element, systemId);
        this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
    }

    public SAML2AssertionKeyIdentifier(Document owner) {
        super(owner);
        this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
    }

    public SAML2AssertionKeyIdentifier(Document owner, byte[] assertionId) {
        super(owner);
        this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        this.setValue(assertionId);
    }

    public SAML2AssertionKeyIdentifier(Document owner, String valueType) {
        super(owner);
        this.setValueType(valueType);
    }

    public SAML2AssertionKeyIdentifier(Document owner, byte[] assertionId, String valueType) {
        this(owner);
        this.setValueType(valueType);
        this.setValue(assertionId);
    }

    public SAML2AssertionKeyIdentifier(Document owner, String assertionId, String valueType) {
        this(owner);
        if (valueType == null) {
            this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID");
        } else {
            this.setValueType(valueType);
        }
        this.setValue(WSSTokenUtils.createBinaryDataEncoder(this.getEncodingType()).decode(assertionId));
    }

    @Override
    public WSSecurityToken getSecurityToken() throws WSSException {
        Assertion as = null;
        int n = resolverList.size();
        for (int i = 0; i < n && as == null; ++i) {
            SAML2AssertionKeyIdentifierResolver r = (SAML2AssertionKeyIdentifierResolver)resolverList.get(i);
            try {
                as = r.resolve(this, this.getValueType());
                continue;
            }
            catch (SAML2AssertionKeyIdentifierResolverException ex) {
                as = null;
            }
        }
        if (as == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        return new SAML2AssertionToken(as);
    }

    public X509Certificate getPublicKey() throws WSSException {
        X509Certificate as = null;
        if (as == null) {
            int n = resolverList.size();
            for (int i = 0; i < n && as == null; ++i) {
                SAML2AssertionKeyIdentifierResolver r = (SAML2AssertionKeyIdentifierResolver)resolverList.get(i);
                try {
                    as = r.getPublicKey(this, this.getValueType());
                    continue;
                }
                catch (SAML2AssertionKeyIdentifierResolverException ex) {
                    as = null;
                }
            }
        }
        return as;
    }

    public PrivateKey getPrivateKey() throws WSSException {
        PrivateKey as = null;
        if (as == null) {
            int n = resolverList.size();
            for (int i = 0; i < n && as == null; ++i) {
                SAML2AssertionKeyIdentifierResolver r = (SAML2AssertionKeyIdentifierResolver)resolverList.get(i);
                try {
                    as = r.getPrivateKey(this, this.getValueType());
                    continue;
                }
                catch (SAML2AssertionKeyIdentifierResolverException ex) {
                    as = null;
                }
            }
        }
        if (as == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        return as;
    }

    @Override
    public Object getKey() throws WSSException {
        throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
    }

    @Override
    protected String getDefaultEncodingType() {
        return null;
    }

    static {
        SAML2Initializer.initialize();
    }
}

