/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.saml;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.saml.Assertion;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.wss.WSSXMLSecurityToken;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SAMLAssertionToken
extends Assertion
implements WSSXMLSecurityToken {
    boolean alreadyValidatedCerts = false;

    public SAMLAssertionToken(Element element) {
        super(element);
    }

    public SAMLAssertionToken(Element element, String systemId) {
        super(element, systemId);
    }

    public SAMLAssertionToken(Assertion assertion) {
        super((Element)assertion.getNode());
    }

    @Override
    public QName getTokenName() {
        return new QName("Assertion", "urn:oasis:names:tc:SAML:1.0:assertion", null);
    }

    @Override
    public Object getToken() {
        return this;
    }

    public void validateCerts() throws KeyRetrievalException {
        if (this.alreadyValidatedCerts) {
            return;
        }
        Vector certs = this.retrieveX509List();
        if (certs != null && certs.size() > 0) {
            KeyRetriever.validateCertificate((Vector)certs);
        }
    }

    public X509Certificate retrieveX509() {
        Vector v = this.retrieveX509List();
        if (v != null && v.size() > 0) {
            return (X509Certificate)v.get(0);
        }
        return null;
    }

    public Vector retrieveX509List() {
        Assertion assertion = (Assertion)this.getToken();
        NodeList nl = assertion.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation");
        int nlen = nl.getLength();
        for (int ii = 0; ii < nlen && nlen > 0; ++ii) {
            Vector v;
            NodeList enl = XMLElement.getChildElementsByTagNameNS((Element)((Element)nl.item(ii)), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"KeyInfo");
            int enlen = nl.getLength();
            if (enlen == 0 || enlen > 1) {
                return null;
            }
            XSKeyInfo xk = new XSKeyInfo((Element)enl.item(0));
            if (!xk.getType().equals("http://www.w3.org/2000/09/xmldsig#X509Data") || (v = xk.getX509Data()) == null || v.size() <= 0) continue;
            for (int x = 0; x < v.size(); ++x) {
                X509Data xd = (X509Data)v.elementAt(x);
                try {
                    Vector cc = xd.getCertificates();
                    if (cc == null || cc.size() <= 0) continue;
                    return cc;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

