/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.saml;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.saml.Assertion;
import oracle.security.xmlsec.saml.AuthorityBinding;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifierResolver;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifierResolverException;
import oracle.security.xmlsec.wss.saml.SAMLAssertionToken;
import oracle.security.xmlsec.wss.util.WSSTokenUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLAssertionKeyIdentifier
extends WSSKeyIdentifier {
    private static ArrayList resolverList = new ArrayList();
    private AuthorityBinding authorityBinding;

    public static void addResolver(SAMLAssertionKeyIdentifierResolver resolver) {
        resolverList.add(resolver);
    }

    public static List getResolvers() {
        return resolverList;
    }

    public SAMLAssertionKeyIdentifier(Element element) {
        super(element);
        this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
    }

    public SAMLAssertionKeyIdentifier(Element element, String systemId) {
        super(element, systemId);
        this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
    }

    public SAMLAssertionKeyIdentifier(Document owner) {
        super(owner);
        this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
    }

    public SAMLAssertionKeyIdentifier(Document owner, byte[] assertionId) {
        super(owner);
        this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        this.setValue(assertionId);
    }

    public SAMLAssertionKeyIdentifier(Document owner, String valueType) {
        super(owner);
        this.setValueType(valueType);
    }

    public SAMLAssertionKeyIdentifier(Document owner, byte[] assertionId, String valueType) {
        this(owner);
        this.setValueType(valueType);
        this.setValue(assertionId);
    }

    public SAMLAssertionKeyIdentifier(Document owner, String assertionId, String valueType) {
        this(owner);
        if (valueType == null) {
            this.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        } else {
            this.setValueType(valueType);
        }
        this.setValue(WSSTokenUtils.createBinaryDataEncoder(this.getEncodingType()).decode(assertionId));
    }

    public void setAuthorityBinding(AuthorityBinding authorityBinding) {
        this.authorityBinding = authorityBinding;
    }

    public AuthorityBinding getAuthorityBinding() {
        return this.authorityBinding;
    }

    @Override
    public WSSecurityToken getSecurityToken() throws WSSException {
        Assertion as = null;
        int n = resolverList.size();
        for (int i = 0; i < n && as == null; ++i) {
            SAMLAssertionKeyIdentifierResolver r = (SAMLAssertionKeyIdentifierResolver)resolverList.get(i);
            try {
                as = r.resolve(this, this.getValueType(), this.authorityBinding);
                continue;
            }
            catch (SAMLAssertionKeyIdentifierResolverException ex) {
                as = null;
            }
        }
        if (as == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        SAMLAssertionToken samlToken = new SAMLAssertionToken(as);
        return samlToken;
    }

    public X509Certificate getPublicKey() throws WSSException {
        X509Certificate as = null;
        if (as == null) {
            int n = resolverList.size();
            for (int i = 0; i < n && as == null; ++i) {
                SAMLAssertionKeyIdentifierResolver r = (SAMLAssertionKeyIdentifierResolver)resolverList.get(i);
                try {
                    as = r.getPublicKey(this, this.getValueType(), this.authorityBinding);
                    continue;
                }
                catch (SAMLAssertionKeyIdentifierResolverException ex) {
                    as = null;
                }
            }
        }
        if (as == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        return as;
    }

    public PrivateKey getPrivateKey() throws WSSException {
        PrivateKey as = null;
        if (as == null) {
            int n = resolverList.size();
            for (int i = 0; i < n && as == null; ++i) {
                SAMLAssertionKeyIdentifierResolver r = (SAMLAssertionKeyIdentifierResolver)resolverList.get(i);
                try {
                    as = r.getPrivateKey(this, this.getValueType(), this.authorityBinding);
                    continue;
                }
                catch (SAMLAssertionKeyIdentifierResolverException ex) {
                    as = null;
                }
            }
        }
        if (as == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        return as;
    }

    @Override
    public Object getKey() throws WSSException {
        throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
    }

    @Override
    protected String getDefaultEncodingType() {
        return null;
    }
}

