/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import java.util.Hashtable;
import oracle.security.xmlsec.soap.v11.SOAPEnvelope;
import oracle.security.xmlsec.util.ChainedException;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSException
extends ChainedException {
    public static final QName UNSUPPORTED_SECURITY_TOKEN = new QName("UnsupportedSecurityToken", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    public static final QName UNSUPPORTED_ALGORITHM = new QName("UnsupportedAlgorithm", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    public static final QName INVALID_SECURITY = new QName("InvalidSecurity", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    public static final QName INVALID_SECURITY_TOKEN = new QName("InvalidSecurityToken", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    public static final QName FAILED_AUTHENTICATION = new QName("FailedAuthentication", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    public static final QName FAILED_CHECK = new QName("FailedCheck", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    public static final QName SECURITY_TOKEN_UNAVAILABLE = new QName("SecurityTokenUnavailable", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    public static final QName MESSAGE_EXPIRED = new QName("MessageExpired", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    private QName faultcode = INVALID_SECURITY_TOKEN;
    private static Hashtable errStrings;
    private String faultString;
    private String traceString;

    synchronized void init() {
        errStrings = new Hashtable();
        errStrings.put(UNSUPPORTED_SECURITY_TOKEN, new String("An unsupported token was provided"));
        errStrings.put(UNSUPPORTED_ALGORITHM, new String("An unsupported tsignature or encryption algorithm was used"));
        errStrings.put(INVALID_SECURITY, new String("An error was discovered while processing the wsse:Security header"));
        errStrings.put(INVALID_SECURITY_TOKEN, new String("An invalid token was provided"));
        errStrings.put(FAILED_AUTHENTICATION, new String("The security token could not be authenticated or authorized"));
        errStrings.put(FAILED_CHECK, new String("The signature or decryption was invalid"));
        errStrings.put(SECURITY_TOKEN_UNAVAILABLE, new String("The referenced security token could not be retrieved"));
        this.faultcode = INVALID_SECURITY_TOKEN;
        this.faultString = (String)errStrings.get(this.faultcode);
    }

    public WSSException() {
        this.init();
    }

    public WSSException(String message) {
        super(message);
        this.init();
    }

    public WSSException(QName faultcode) {
        this.init();
        this.faultcode = faultcode;
        this.faultString = (String)errStrings.get(faultcode);
        if (this.faultString == null || this.faultString.length() == 0) {
            this.faultString = "Fault String is not pre-defined";
        }
    }

    public WSSException(Throwable cause, QName faultcode) {
        super(cause);
        this.init();
        this.faultcode = faultcode;
        this.faultString = (String)errStrings.get(faultcode);
        if (this.faultString == null || this.faultString.length() == 0) {
            this.faultString = "Fault String is not pre-defined";
        }
    }

    public WSSException(QName faultcode, String faultString) {
        this.init();
        this.faultcode = faultcode;
        this.faultString = faultString;
    }

    public QName getFaultCode() {
        return this.faultcode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getTraceString() {
        return "";
    }

    public String getMessage() {
        String msg = "FAULT CODE: " + this.faultcode.toString();
        if (this.faultString != null) {
            msg = msg + " FAULT MESSAGE: " + this.faultString;
        }
        return msg;
    }

    public String toString() {
        return this.getMessage();
    }

    public SOAPEnvelope createSOAPFault() {
        Document doc = XMLUtils.createDocument();
        SOAPEnvelope env = new SOAPEnvelope(doc);
        env.appendTo((Node)doc);
        Element soapFault = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
        XMLUtils.copyNSPrefix((Element)((Element)env.getNode()), (Element)soapFault);
        Element fc = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "faultcode");
        QName faultCode = this.getFaultCode();
        String fcString = faultCode.getLocalPart();
        String nsURI = faultCode.getNamespace();
        if (nsURI != null) {
            String prefix = faultCode.getPrefix();
            fcString = prefix + ":" + fcString;
            XMLElement.addNSPrefixAttr((Element)fc, (String)prefix, (String)nsURI);
        }
        fc.appendChild(doc.createTextNode(fcString));
        soapFault.appendChild(fc);
        env.addBodyElement(soapFault);
        return env;
    }

    public oracle.security.xmlsec.soap.v12.SOAPEnvelope createSOAPFault12() {
        Document doc = XMLUtils.createDocument();
        oracle.security.xmlsec.soap.v12.SOAPEnvelope env = new oracle.security.xmlsec.soap.v12.SOAPEnvelope(doc);
        env.appendTo((Node)doc);
        Element soapFault = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Fault");
        XMLUtils.copyNSPrefix((Element)((Element)env.getNode()), (Element)soapFault);
        Element code = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Code");
        XMLUtils.copyNSPrefix((Element)((Element)env.getNode()), (Element)code);
        Element value = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Value");
        XMLUtils.copyNSPrefix((Element)((Element)env.getNode()), (Element)value);
        value.appendChild(doc.createTextNode("env:Sender"));
        Element subcode = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "SubCode");
        XMLUtils.copyNSPrefix((Element)((Element)env.getNode()), (Element)subcode);
        Element subvalue = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Value");
        XMLUtils.copyNSPrefix((Element)((Element)env.getNode()), (Element)subvalue);
        subvalue.appendChild(doc.createTextNode(this.getFaultCode().getLocalPart()));
        subcode.appendChild(subvalue);
        code.appendChild(value);
        code.appendChild(subcode);
        soapFault.appendChild(code);
        Element reason = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Reason");
        XMLUtils.copyNSPrefix((Element)((Element)env.getNode()), (Element)reason);
        reason.appendChild(doc.createTextNode(this.getFaultString()));
        soapFault.appendChild(reason);
        env.addBodyElement(soapFault);
        return env;
    }
}

