/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizardx.gui.table;

import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizardx.gui.table.DecoratedTableModel;
import com.oracle.cie.wizardx.gui.table.messages.CellDecorationSupport;
import com.oracle.cie.wizardx.gui.table.messages.CellDecorationType;
import com.oracle.cie.wizardx.gui.table.messages.DefaultTableMessageHandler;
import com.oracle.cie.wizardx.gui.table.messages.TableCell;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class DecoratedJTable
extends JTable
implements CellDecorationSupport {
    public static final int DASHED_RECT_GAP = 2;

    public DecoratedJTable(GUITaskContext taskContext, DecoratedTableModel model) {
        super(model);
        DefaultTableMessageHandler _messageHandler = new DefaultTableMessageHandler(taskContext, this, this.getModel());
        model.setMessageHandler(_messageHandler);
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        this.setShowGrid(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(this.getRowHeight() + 4);
        this.setAutoResizeMode(1);
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof DecoratedTableModel)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " only accepts TableModel of type " + DecoratedTableModel.class.getSimpleName());
        }
        super.setModel(dataModel);
    }

    @Override
    public void cellValueChanging(int row, int column) {
        this.getModel().clearValidationMessages(row, this.getColumnModel().getColumn(column).getModelIndex());
    }

    @Override
    public CellDecorationType getDecorationType(int row, int column) {
        return this.getModel().getDecorationType(row, this.getColumnModel().getColumn(column).getModelIndex());
    }

    @Override
    public DecoratedTableModel getModel() {
        return (DecoratedTableModel)super.getModel();
    }

    public boolean stopEditing() {
        TableCellEditor e = this.getCellEditor();
        return e == null || e.stopCellEditing();
    }

    public void cancelEditing() {
        TableCellEditor e = this.getCellEditor();
        if (e != null) {
            e.cancelCellEditing();
        }
    }

    public TableCell findNextTraversableCell(int rowIndex, int colIndex) {
        if (!this.isCellEditable(rowIndex, colIndex)) {
            int curRow = this.getSelectedRow();
            int curCol = this.getSelectedColumn();
            int rowCount = this.getRowCount();
            int colCount = this.getColumnCount();
            int nextRow = rowIndex;
            int nextCol = colIndex;
            if (colIndex == curCol) {
                int direction = rowIndex - curRow;
                if (direction > 1) {
                    direction = 1;
                }
                if (direction < -1) {
                    direction = -1;
                }
                nextRow = this.findNextRow(rowIndex, colIndex, direction, rowCount, colCount);
            } else if (rowIndex == curRow) {
                int direction = colIndex - curCol;
                if (direction > 1) {
                    direction = 1;
                }
                if (direction < -1) {
                    direction = -1;
                }
                TableCell nextCell = this.findNextCell(rowIndex, colIndex, direction, rowCount, colCount);
                nextRow = nextCell.getRow();
                nextCol = nextCell.getCol();
            } else {
                int direction = rowIndex - curRow;
                if (direction > 1) {
                    direction = 1;
                }
                if (direction < -1) {
                    direction = -1;
                }
                if (rowIndex == 0 && curRow == rowCount - 1) {
                    direction = 1;
                }
                if (curRow == 0 && curCol == 0 && rowIndex == rowCount - 1 && colIndex == colCount - 1) {
                    direction = -1;
                }
                TableCell nextCell = this.findNextCell(rowIndex, colIndex, direction, rowCount, colCount);
                nextRow = nextCell.getRow();
                nextCol = nextCell.getCol();
            }
            return new TableCell(nextRow, nextCol);
        }
        return new TableCell(rowIndex, colIndex);
    }

    private TableCell findNextCell(int rowIndex, int colIndex, int direction, int rowCount, int colCount) {
        int origRow = rowIndex;
        int origCol = colIndex;
        do {
            if ((colIndex += direction) >= colCount) {
                colIndex = 0;
                rowIndex += direction;
            }
            if (colIndex < 0) {
                colIndex = colCount - 1;
                rowIndex += direction;
            }
            if (rowIndex >= rowCount) {
                rowIndex = 0;
            }
            if (rowIndex < 0) {
                rowIndex = rowCount - 1;
            }
            if (!this.isCellEditable(rowIndex, colIndex)) continue;
            return new TableCell(rowIndex, colIndex);
        } while (rowIndex != origRow || colIndex != origCol);
        return new TableCell(origRow, origCol);
    }

    private int findNextRow(int rowIndex, int colIndex, int direction, int rowCount, int colCount) {
        int origRow = rowIndex;
        do {
            if ((rowIndex += direction) < 0) {
                rowIndex = rowCount - 1;
            }
            if (rowIndex >= rowCount) {
                rowIndex = 0;
            }
            if (!this.isCellEditable(rowIndex, colIndex)) continue;
            return rowIndex;
        } while (rowIndex != origRow);
        return origRow;
    }
}

