/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizardx.gui.table;

import com.oracle.cie.wizardx.gui.table.MultiLineTableHeaderRenderer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class CheckBoxTableHeaderCellRenderer
extends MultiLineTableHeaderRenderer {
    protected int _column;
    protected JCheckBox _checkBox;

    public CheckBoxTableHeaderCellRenderer(JTable table, int column) {
        super(table);
        this._column = column;
        this._checkBox = new JCheckBox();
        this._checkBox.setOpaque(false);
        this._checkBox.setSelected(this.areAllRowsSelected());
        this._checkBox.setHorizontalAlignment(0);
        Insets i = this._panel.getBorder().getBorderInsets(this._panel);
        if (i != null && i.right != i.left) {
            this._checkBox.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, i.right, 0, i.left), this._checkBox.getBorder()));
        }
        this._panel.add((Component)this._checkBox, "South");
        this._checkBox.addActionListener(new HeaderCheckBoxListener());
        JTableHeader header = table.getTableHeader();
        table.getModel().addTableModelListener(new HeaderTableModelListener());
        if (header != null) {
            header.addMouseListener(new HeaderMouseAdapter());
        }
    }

    protected boolean areAllRowsSelected() {
        if (this._table.getModel().getRowCount() == 0) {
            return false;
        }
        boolean hasEditableRows = false;
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            try {
                if (!this._table.getModel().isCellEditable(i, this._column)) continue;
                hasEditableRows = true;
                if (((Boolean)this._table.getModel().getValueAt(i, this._column)).booleanValue()) continue;
                return false;
            }
            catch (Throwable th) {
                return false;
            }
        }
        return hasEditableRows;
    }

    protected class HeaderCheckBoxListener
    implements ActionListener {
        protected HeaderCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox source = (JCheckBox)e.getSource();
            boolean checkBoxState = source.isSelected();
            if (CheckBoxTableHeaderCellRenderer.this._table.isEditing()) {
                CheckBoxTableHeaderCellRenderer.this._table.getCellEditor().stopCellEditing();
            }
            for (int row = 0; row < CheckBoxTableHeaderCellRenderer.this._table.getRowCount(); ++row) {
                CheckBoxTableHeaderCellRenderer.this._table.getModel().setValueAt(checkBoxState, row, CheckBoxTableHeaderCellRenderer.this._column);
            }
        }
    }

    protected class HeaderTableModelListener
    implements TableModelListener {
        protected HeaderTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            boolean allSelected;
            if ((e.getColumn() == -1 || CheckBoxTableHeaderCellRenderer.this._table.convertColumnIndexToModel(e.getColumn()) == CheckBoxTableHeaderCellRenderer.this._column) && (allSelected = CheckBoxTableHeaderCellRenderer.this.areAllRowsSelected()) != CheckBoxTableHeaderCellRenderer.this._checkBox.isSelected()) {
                CheckBoxTableHeaderCellRenderer.this._checkBox.setSelected(allSelected);
                JTableHeader header = CheckBoxTableHeaderCellRenderer.this._table.getTableHeader();
                if (header != null) {
                    header.repaint();
                }
            }
        }
    }

    protected class HeaderMouseAdapter
    extends MouseAdapter {
        protected HeaderMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader header = (JTableHeader)e.getSource();
            TableColumnModel columnModel = CheckBoxTableHeaderCellRenderer.this._table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = CheckBoxTableHeaderCellRenderer.this._table.convertColumnIndexToModel(viewColumn);
            if (column == CheckBoxTableHeaderCellRenderer.this._column && e.getClickCount() == 1) {
                CheckBoxTableHeaderCellRenderer.this._checkBox.doClick();
            }
            header.repaint();
        }
    }
}

