/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizardx.gui.table;

import com.oracle.cie.common.ui.gui.GUIHelper;
import com.oracle.cie.wizardx.gui.table.messages.CellDecorationSupport;
import com.oracle.cie.wizardx.gui.table.messages.CellDecorationType;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public abstract class AbstractTableCellDecorator {
    public static final Border DEFAULT_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    public static final Border WARNING_BORDER = BorderFactory.createLineBorder(GUIHelper.WARNING_COLOR, 1);
    public static final Border ERROR_BORDER = BorderFactory.createLineBorder(GUIHelper.ERROR_COLOR, 1);
    public static final Border TEXT_PADDING_BORDER = new EmptyBorder(new Insets(1, 4, 1, 2));

    public static JComponent decorateComponent(JComponent comp, JTable table, boolean hasFocus, boolean isSelected, int row, int column, boolean triggerBorderDecoration) {
        CellDecorationType decoration = null;
        Border border = null;
        if (triggerBorderDecoration) {
            if (table instanceof CellDecorationSupport) {
                decoration = ((CellDecorationSupport)((Object)table)).getDecorationType(row, column);
            }
            if (decoration == null) {
                decoration = CellDecorationType.NONE;
            }
            switch (decoration) {
                case ERROR: {
                    border = ERROR_BORDER;
                    break;
                }
                case WARNING: {
                    border = WARNING_BORDER;
                }
            }
        }
        if (hasFocus && border == null) {
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
        }
        if (!(comp instanceof JComboBox) && !(comp instanceof JCheckBox)) {
            comp.setBorder(new CompoundBorder(border != null ? border : DEFAULT_BORDER, TEXT_PADDING_BORDER));
        } else {
            comp.setBorder(border != null ? border : DEFAULT_BORDER);
        }
        return comp;
    }
}

