/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.common.util.StringsubsEngine;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;

@TaskDescription(name="wstringsubs")
public class WizardStringsubsTask
extends AbstractSilentTask {
    private String _configFile = null;
    private String _components = null;
    private StringsubsEngine _engine = null;

    @TaskAttribute(type=TaskAttributeType.RESOURCE_KEY, required=true)
    public void setConfigFile(String file) {
        this._configFile = file;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setComponents(String components) {
        this._components = components;
    }

    @Override
    public void execute() throws TaskExecutionException {
        if (this._configFile == null || this._configFile.equals("")) {
            this._logger.severe("configFile must be specified");
            return;
        }
        this._configFile = this._context.substitute(this._namespace, this._configFile);
        if (this._components == null || this._components.equals("")) {
            this._logger.severe("components must be specified");
            return;
        }
        try {
            this._engine = new StringsubsEngine(this._configFile);
        }
        catch (StringsubsEngine.StringsubsEngineException sse) {
            this._logger.severe("Missing or invalid stringsubs configuration file " + this._configFile);
            throw new TaskExecutionException(this, "Missing or invalid stringsubs configuration file " + this._configFile);
        }
        this._engine.execute(this._namespace, this._components);
    }
}

