/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.Arrays;
import java.util.List;

@TaskDescription(name="string2List", cachingPolicy=TaskCachingPolicy.REUSE)
public class String2ListTask
extends AbstractSilentTask {
    private String _regex = null;
    private String _stringKey = null;
    private String _storageKey = null;

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setRegex(String regex) {
        this._regex = regex;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setStringKey(String key) {
        this._stringKey = key;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setStorageKey(String key) {
        this._storageKey = key;
    }

    @Override
    public void execute() throws TaskExecutionException {
        String value = this._context.getString(this._namespace, this._stringKey);
        String[] tokens = value.split(this._regex);
        List<String> tokenList = Arrays.asList(tokens);
        this._context.storeObject(this._namespace, this._storageKey, tokenList);
    }

    @Override
    public void unconfigure() {
        this._regex = null;
        this._stringKey = null;
        this._storageKey = null;
    }
}

