/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.logging.Level;

@TaskDescription(name="log", cachingPolicy=TaskCachingPolicy.REUSE)
public class LogTask
extends AbstractSilentTask {
    protected String _message = "";
    protected String _priority = "INFO";

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setMessage(String msg) {
        this._message = msg;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, defaultValue="INFO")
    public void setPriority(String priority) {
        this._priority = priority;
    }

    @Override
    public void execute() throws TaskExecutionException {
        Level level = Level.INFO;
        try {
            level = Level.parse(this._priority);
        }
        catch (IllegalArgumentException ex) {
            this._logger.log(Level.INFO, "Invalid priority parameter", ex);
        }
        this._logger.log(level, this._message);
    }
}

