/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.logging.Level;

@TaskDescription(name="logKey", cachingPolicy=TaskCachingPolicy.REUSE)
public class LogKeyTask
extends AbstractSilentTask {
    private String _key = "";
    private String _priority = "INFO";

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY, required=true)
    public void setKey(String key) {
        this._key = key;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, defaultValue="INFO")
    public void setPriority(String priority) {
        this._priority = priority;
    }

    @Override
    public void execute() throws TaskExecutionException {
        Object value = this._context.retrieveObject(this._namespace, this._key);
        Level level = Level.INFO;
        try {
            level = Level.parse(this._priority);
        }
        catch (IllegalArgumentException ex) {
            this._logger.log(Level.INFO, "Invalid priority parameter", ex);
        }
        this._logger.log(level, "The key " + this._key + " has a value of <" + value + ">");
    }
}

