/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.ext.OperationException;
import com.oracle.cie.wizard.ext.SilentTaskOperator;
import com.oracle.cie.wizard.ext.impl.DefaultTaskHelper;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskContext;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.logging.Level;

@TaskDescription(name="silent_operator_task")
public class ExternalSilentOperationTask
extends AbstractSilentTask {
    private SilentTaskOperator _operator;
    private String _operatorClassName;

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"com.oracle.cie.wizard.ext.SilentTaskOperator"}, required=true)
    public void setOperatorClassName(String clazz) {
        this._operatorClassName = clazz;
    }

    @Override
    public void configure(TaskContext context) throws TaskExecutionException {
        super.configure(context);
        try {
            ClassLoader classLoader = ExternalSilentOperationTask.class.getClassLoader();
            Class<?> loaderClass = classLoader.loadClass(this._operatorClassName);
            this._operator = (SilentTaskOperator)loaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this._operator == null) {
                throw new TaskExecutionException(this, "Unable to initialze silent task operator :: " + this._operatorClassName);
            }
        }
        catch (TaskExecutionException e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw new TaskExecutionException(this, this._context.getPublishedMessage(this._namespace, "64040", this._operatorClassName).getFullMessage(), e);
        }
    }

    @Override
    public void execute() throws TaskExecutionException {
        try {
            this._operator.silentExecution(new DefaultTaskHelper(this._context));
        }
        catch (OperationException e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw new TaskExecutionException(this, "Error in execution of silent operation defined in class:" + this._operatorClassName, e);
        }
    }
}

