/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.logging.Level;

@TaskDescription(name="copyObjStoreValue", cachingPolicy=TaskCachingPolicy.REUSE)
public class CopyObjectStoreValueTask
extends AbstractSilentTask {
    protected String _toKey = null;
    protected String _fromKey = null;
    protected String _fromNamespace = null;
    protected String _toNamespace = null;
    protected boolean _remove = false;

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY, required=true)
    public void setToKey(String key) {
        this._toKey = key;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY, required=true)
    public void setFromKey(String key) {
        this._fromKey = key;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setFromNamespace(String from) {
        this._fromNamespace = from;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setToNamespace(String to) {
        this._toNamespace = to;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setRemove(String remove) {
        this._remove = Boolean.parseBoolean(remove);
    }

    @Override
    public void execute() throws TaskExecutionException {
        String fromNamespace = this._context.substitute(this._namespace, this._fromNamespace);
        String fromKey = this._context.substitute(this._namespace, this._fromKey);
        String toNamespace = this._context.substitute(this._namespace, this._toNamespace);
        String toKey = this._context.substitute(this._namespace, this._toKey);
        Object value = this._context.retrieveObject(fromNamespace, fromKey);
        this._context.storeObject(toNamespace, toKey, value);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Copied: " + fromKey + "=" + value + " from <" + fromNamespace + "> to <" + toNamespace + ">" + toKey);
        }
        if (this._remove) {
            this._context.removeObject(fromNamespace, fromKey);
        }
    }

    @Override
    public void unconfigure() {
        this._toNamespace = null;
        this._fromNamespace = null;
        this._toKey = null;
        this._fromKey = null;
        this._remove = false;
    }
}

