/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.helpers.SetTaskHelper;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import java.util.Arrays;

public abstract class AbstractSetSilentTask
extends AbstractSilentTask {
    protected SetTaskHelper.Target _target = SetTaskHelper.Target.objectstore;
    protected String _targetKey;
    protected SetTaskHelper.AttrType _targetKeyType = SetTaskHelper.AttrType.value;

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"objectstore", "workflow", "os_wf"}, defaultValue="objectstore")
    public void setTarget(String target) {
        try {
            this._target = SetTaskHelper.Target.valueOf(target);
        }
        catch (Exception ex) {
            this._logger.warning("Unsupported target: " + target + ". Supported values: " + Arrays.toString((Object[])SetTaskHelper.Target.values()));
        }
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setTargetKey(String targetKey) {
        this._targetKey = targetKey;
    }

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"value", "os_key", "os_subst", "rs_key", "rs_subst"}, defaultValue="value")
    public void setTargetKeyType(String keyType) {
        try {
            this._targetKeyType = SetTaskHelper.AttrType.valueOf(keyType);
        }
        catch (Exception ex) {
            this._logger.warning("Unsupported keyType: " + keyType + ". Supported values: " + Arrays.toString((Object[])SetTaskHelper.AttrType.values()));
        }
    }

    @Override
    public void unconfigure() {
        this._target = SetTaskHelper.Target.objectstore;
        this._targetKey = null;
        this._targetKeyType = SetTaskHelper.AttrType.value;
    }

    protected void setKeyOnTarget(String value) {
        SetTaskHelper.setKeyOnTarget(this._context, this._namespace, this._target != null ? this._target : SetTaskHelper.Target.objectstore, this.getAttributeValue(this._targetKeyType, this._targetKey), value);
    }

    protected String getAttributeValue(SetTaskHelper.AttrType type, String attrValue) {
        return SetTaskHelper.getAttributeValue(this._context, this._namespace, type, attrValue);
    }
}

