/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.xml.ObjectFactory;
import com.oracle.cie.wizard.internal.wcf.xml.TaskDefinitionsType;
import com.oracle.cie.wizard.internal.wcf.xml.WizardControlFileType;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

class WCFParser {
    protected static Logger _log = Logger.getLogger(WCFParser.class.getName());
    private ValidationEventHandler _validationHandler;
    private Map<String, Unmarshaller> _unmarshallers = new HashMap<String, Unmarshaller>();
    private static Map<Class<?>, String> _schemas = new HashMap();

    WCFParser(ValidationEventHandler validationHandler) {
        this._validationHandler = validationHandler != null ? validationHandler : new WCFValidationEventHandler();
    }

    public WizardControlFileType parseWCF(String xmlFileName) throws ExecPlanException {
        return this.parseWCF(xmlFileName, WCFParser.class.getClassLoader());
    }

    public WizardControlFileType parseWCF(String xmlFileName, ClassLoader cl) throws ExecPlanException {
        return (WizardControlFileType)this.parse(WizardControlFileType.class, cl, xmlFileName).getValue();
    }

    public TaskDefinitionsType parseTDFile(String xmlFileName) throws ExecPlanException {
        return this.parseTDFile(xmlFileName, WCFParser.class.getClassLoader());
    }

    public TaskDefinitionsType parseTDFile(String xmlFileName, ClassLoader cl) throws ExecPlanException {
        return (TaskDefinitionsType)this.parse(TaskDefinitionsType.class, cl, xmlFileName).getValue();
    }

    private <T> JAXBElement<T> parse(Class<T> type, ClassLoader cl, String xmlResPath) throws ExecPlanException {
        if (cl == null) {
            throw new IllegalArgumentException("You must supply a ClassLoader instance!");
        }
        String schemaLoc = _schemas.get(type);
        Unmarshaller unmarshaller = this._unmarshallers.get(schemaLoc);
        if (unmarshaller == null) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                unmarshaller = context.createUnmarshaller();
                unmarshaller.setEventHandler(this._validationHandler);
            }
            catch (JAXBException e) {
                throw new ExecPlanException("Unable to create unmarshaller for schema " + schemaLoc);
            }
            if (schemaLoc != null) {
                try {
                    SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    Schema schema = schemaFactory.newSchema(WCFParser.class.getClassLoader().getResource(schemaLoc));
                    unmarshaller.setSchema(schema);
                }
                catch (Exception e) {
                    _log.warning("Unable to load schema " + schemaLoc);
                }
            }
            this._unmarshallers.put(schemaLoc, unmarshaller);
        }
        try {
            URL loc = cl.getResource(xmlResPath);
            if (loc == null) {
                throw new ExecPlanException(xmlResPath + " is not found on the class-path.");
            }
            return (JAXBElement)unmarshaller.unmarshal(loc);
        }
        catch (JAXBException e) {
            throw new ExecPlanException("Unable to parse WCF file: " + xmlResPath, (Exception)((Object)e));
        }
    }

    static {
        _schemas.put(WizardControlFileType.class, "wcf/schema/wizard-control-file.xsd");
        _schemas.put(TaskDefinitionsType.class, "wcf/schema/task-definitions.xsd");
    }

    protected static class WCFValidationEventHandler
    implements ValidationEventHandler {
        protected WCFValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent ve) {
            ValidationEventLocator vel = ve.getLocator();
            String msg = "[" + vel.getURL() + " - line:" + vel.getLineNumber() + ", column:" + vel.getColumnNumber() + "] " + ve.getMessage();
            switch (ve.getSeverity()) {
                case 1: 
                case 2: {
                    _log.warning(msg);
                    break;
                }
                default: {
                    _log.info(msg);
                }
            }
            return true;
        }
    }
}

