/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.EntryElem;
import com.oracle.cie.wizard.internal.wcf.LoopElem;
import com.oracle.cie.wizard.internal.wcf.Subflow;
import com.oracle.cie.wizard.internal.wcf.xml.BreakType;
import com.oracle.cie.wizard.internal.wcf.xml.LoopStatementType;
import com.oracle.cie.wizard.wcf.ExecPlanException;

class LoopRefElem<E extends LoopStatementType>
extends EntryElem<E> {
    protected String _loopId = ((LoopStatementType)this.getXmlObject()).getLoopId();

    LoopRefElem(Subflow<?> sequence, E entry) throws ExecPlanException {
        super(sequence, entry);
    }

    @Override
    public void selectedOnNext() throws ExecPlanException {
        LoopElem loop = this.findReferencedLoop();
        if (loop == null) {
            this._log.warning("Unble to locate enclosing loop" + (this._loopId == null ? "." : " with ID: " + this._loopId));
            return;
        }
        if (BreakType.class.isAssignableFrom(((LoopStatementType)this.getXmlObject()).getClass())) {
            loop.removeLoopBody();
            this.getWorkflow().moveIndexTo(loop);
        } else {
            this.getWorkflow().moveIndexBefore(loop);
        }
    }

    private LoopElem findReferencedLoop() {
        EntryElem<?> elem = this.getParentSequence().getParentEntryElem();
        while (elem != null) {
            if (LoopElem.class.isAssignableFrom(elem.getClass())) {
                LoopElem loop = (LoopElem)LoopElem.class.cast(elem);
                if (this._loopId == null || this._loopId.equals(loop.getLoopId())) {
                    return loop;
                }
            }
            elem = elem.getParentSequence().getParentEntryElem();
        }
        return null;
    }
}

