/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.tasks;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.WizardCompletionInfo;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.WizardConfigurationLoader;
import com.oracle.cie.wizard.WizardController;
import com.oracle.cie.wizard.WizardException;
import com.oracle.cie.wizard.WizardState;
import com.oracle.cie.wizard.event.WizardStateChangeEvent;
import com.oracle.cie.wizard.event.WizardStateChangeListener;
import com.oracle.cie.wizard.internal.cont.InternalTaskContext;
import com.oracle.cie.wizard.internal.engine.EmbeddedEngine;
import com.oracle.cie.wizard.internal.tasks.AbstractInternalTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import com.oracle.cie.wizard.tasks.TraversalMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;

@TaskDescription(name="parallelExecution")
public class ParallelExecutionTask
extends AbstractInternalTask
implements WizardStateChangeListener {
    private String _wcfFilePath;
    private String _mode;
    private Map<EmbeddedEngine, WizardState> _embeddedEngineStateMap;
    private String[] _targetNames;
    private volatile ErrorHandleOption _errorHandleOption = ErrorHandleOption.IGNORE;
    private volatile boolean _isRunning;
    private String _collectionKey;
    private String _collectionValueKey;
    private boolean _createNewClassloader;
    private Map<EmbeddedEngine, Thread> _embeddedEngineThreadMap;
    private static final String DEFAULT_WIZARD_CONFIG = "com.oracle.cie.wizard.internal.engine.DefaultWizardConfiguration";
    private static final String DEFAULT_EMBEDDED_ENGINE_THREAD_NAME = "EmbeddedEngine_";
    public static final String EMBEDDED_WIZARD_ENGINE_THREAD_GROUP_NAME_PREFIX = "ParalledEmbeddedEngineGroup_";

    @TaskAttribute(required=true, type=TaskAttributeType.LITERAL)
    public void setWcfFilePath(String wcfFilePath) {
        this._wcfFilePath = wcfFilePath;
    }

    @TaskAttribute(required=false, type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setCollectionKey(String collectionKey) {
        this._collectionKey = collectionKey;
    }

    @TaskAttribute(required=false, type=TaskAttributeType.LITERAL)
    public void setCollectionValueKey(String collectionValueKey) {
        this._collectionValueKey = collectionValueKey;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setMode(String mode) {
        String[] supportedModes = WizardConfiguration.MODE.getAllowedValues();
        boolean validMode = false;
        for (String supportedMode : supportedModes) {
            if (!supportedMode.equals(mode)) continue;
            this._mode = supportedMode;
            validMode = true;
        }
        if (!validMode) {
            this._logger.log(Level.WARNING, "Mode value [" + mode + "] is not supported.");
            this._mode = ((InternalTaskContext)this._context).getConfiguration().getOptionValue(WizardConfiguration.MODE.getName());
        }
    }

    @TaskAttribute(required=true, type=TaskAttributeType.LITERAL)
    public void setTargetNames(String targetNames) {
        if (!StringUtil.isNullOrEmpty((String)targetNames, (boolean)true)) {
            this._targetNames = targetNames.split(",");
        }
    }

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"ABORT", "IGNORE"}, defaultValue="IGNORE")
    public void setErrorHandleOption(String target) {
        try {
            this._errorHandleOption = ErrorHandleOption.valueOf(target.toUpperCase());
        }
        catch (Exception ex) {
            this._logger.warning("Unsupported Error handling option: " + target + ". Supported values: " + Arrays.toString((Object[])ErrorHandleOption.values()));
            this._errorHandleOption = ErrorHandleOption.IGNORE;
        }
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, required=false, defaultValue="false")
    public void setCreateNewClassloader(String createNewClassloader) {
        this._createNewClassloader = Boolean.parseBoolean(createNewClassloader);
    }

    @Override
    public void execute() throws TaskExecutionException {
        ControllerProxy proxy = ((InternalTaskContext)this._context).getProxy();
        if (proxy.getTraversalMode() == TraversalMode.REVERSE) {
            return;
        }
        if (this._targetNames == null || this._targetNames.length <= 0) {
            this._logger.log(Level.WARNING, "Missing running target information for the Parallel execution.");
            return;
        }
        if (this._wcfFilePath == null) {
            this._logger.log(Level.WARNING, "Missing WCF file path details, this file contains the information about runnable targets.");
            return;
        }
        this._embeddedEngineStateMap = new HashMap<EmbeddedEngine, WizardState>(this._targetNames.length, 1.0f);
        Collection<Object> collections = null;
        collections = StringUtil.isNullOrEmpty((String)this._collectionKey) ? Arrays.asList(new Object()) : (Collection)((InternalTaskContext)this._context).retrieveObject(this._namespace, this._collectionKey);
        for (Object collObj : collections) {
            for (String targetName : this._targetNames) {
                WizardConfigurationLoader conf = this.getWizardConfiguration(targetName);
                EmbeddedEngine embeddedEngine = new EmbeddedEngine();
                try {
                    embeddedEngine.init(conf);
                    embeddedEngine.getControllerProxy().setLocalObject(this._collectionValueKey, collObj);
                }
                catch (WizardException e) {
                    this._logger.log(Level.WARNING, "Error in initializing subwizard", e);
                    throw new TaskExecutionException(this, "Error in initializing subwizard");
                }
                embeddedEngine.getControllerProxy().addWizardStateChangeListener(this);
                this._embeddedEngineStateMap.put(embeddedEngine, WizardState.CREATED);
            }
        }
        ThreadGroup threadGroup = new ThreadGroup(EMBEDDED_WIZARD_ENGINE_THREAD_GROUP_NAME_PREFIX + Arrays.toString(this._targetNames));
        this._isRunning = true;
        int threadCount = 0;
        this._embeddedEngineThreadMap = new HashMap<EmbeddedEngine, Thread>(this._embeddedEngineStateMap.size());
        for (EmbeddedEngine engine : this._embeddedEngineStateMap.keySet()) {
            Thread thread = new Thread(threadGroup, engine, DEFAULT_EMBEDDED_ENGINE_THREAD_NAME + ++threadCount);
            this._embeddedEngineThreadMap.put(engine, thread);
            thread.setContextClassLoader(engine.getControllerProxy().getTaskClassLoader());
            thread.start();
        }
    }

    @Override
    public synchronized void stateChanged(WizardStateChangeEvent e) {
        boolean notifyParentProcess = false;
        WizardState newState = e.getNewState();
        ControllerProxy engineProxy = e.getWizardController();
        EmbeddedEngine currentEngine = this.getEmbeddedEngine(engineProxy);
        this._logger.log(Level.FINEST, Thread.currentThread().getName() + " State changes:" + (Object)((Object)newState));
        switch (newState) {
            case CREATED: 
            case CONFIGURED: 
            case RUNNING: 
            case SUSPENDED: {
                break;
            }
            case ERROR: {
                Throwable cause = engineProxy.getErrorCause();
                if (this._errorHandleOption == ErrorHandleOption.ABORT) {
                    for (Map.Entry<EmbeddedEngine, WizardState> embEngineStateEntry : this._embeddedEngineStateMap.entrySet()) {
                        if (this.isCompleted(embEngineStateEntry.getValue())) continue;
                        embEngineStateEntry.getKey().getControllerProxy().cancel();
                    }
                } else {
                    this._logger.log(Level.WARNING, "Error occured in Embedded Process", cause);
                }
            }
            case SHUTTING_DOWN: 
            case TERMINATED: {
                notifyParentProcess = true;
                break;
            }
        }
        this._embeddedEngineStateMap.put(currentEngine, newState);
        if (notifyParentProcess) {
            int completedProcessCount = this._embeddedEngineStateMap.size();
            for (WizardState state : this._embeddedEngineStateMap.values()) {
                if (state != WizardState.SHUTTING_DOWN && state != WizardState.TERMINATED) continue;
                this._logger.log(Level.FINE, Thread.currentThread().getName() + " " + (state == WizardState.ERROR ? " has encountered error" : state));
                --completedProcessCount;
            }
            if (completedProcessCount == 0 && this._isRunning) {
                Throwable throwable;
                ControllerProxy proxy = ((InternalTaskContext)this._context).getProxy();
                this._isRunning = false;
                if (this._errorHandleOption == ErrorHandleOption.ABORT && (throwable = this.getEmbeddedEngineError()) != null) {
                    proxy.error(WizardCompletionInfo.getInstance().getFatalErrorCode(), throwable);
                    return;
                }
                if (proxy.getTraversalMode() == TraversalMode.FORWARD) {
                    proxy.goNext();
                } else {
                    proxy.goPrevious();
                }
            }
        }
    }

    private EmbeddedEngine getEmbeddedEngine(ControllerProxy proxy) {
        for (EmbeddedEngine engine : this._embeddedEngineStateMap.keySet()) {
            if (engine.getControllerProxy() != proxy) continue;
            return engine;
        }
        return null;
    }

    private Throwable getEmbeddedEngineError() {
        for (Map.Entry<EmbeddedEngine, WizardState> engineState : this._embeddedEngineStateMap.entrySet()) {
            Throwable e = engineState.getKey().getControllerProxy().getErrorCause();
            if (e == null) continue;
            return e;
        }
        return null;
    }

    private WizardConfigurationLoader getWizardConfiguration(String targetName) {
        HashMap<String, String> options = new HashMap<String, String>(((InternalTaskContext)this._context).getConfiguration().getOptions());
        options.put(WizardConfiguration.CTRLFILE.getName(), this._wcfFilePath);
        options.put(WizardConfiguration.TARGET.getName(), targetName);
        options.put(WizardConfiguration.MODE.getName(), this._mode);
        options.put("createNewEmbProcessClassloader", Boolean.toString(this._createNewClassloader));
        WizardConfigurationLoader loader = null;
        try {
            Iterator<WizardConfigurationLoader> iterator = ServiceLoader.load(WizardConfigurationLoader.class, WizardController.class.getClassLoader()).iterator();
            loader = iterator.hasNext() ? iterator.next() : (WizardConfigurationLoader)WizardConfigurationLoader.class.cast(Class.forName(DEFAULT_WIZARD_CONFIG).newInstance());
        }
        catch (Exception ex) {
            try {
                loader = (WizardConfigurationLoader)WizardConfigurationLoader.class.cast(Class.forName(DEFAULT_WIZARD_CONFIG).newInstance());
            }
            catch (Exception e) {
                this._logger.log(Level.FINER, "Error in loading default wizard configuration:com.oracle.cie.wizard.internal.engine.DefaultWizardConfiguration");
            }
        }
        if (loader != null) {
            loader.setOptions(options);
        }
        return loader;
    }

    @Override
    public boolean isIndependent() {
        return this._isRunning;
    }

    @Override
    public void exiting() {
        block2: for (Map.Entry<EmbeddedEngine, WizardState> embEngineStateEntry : this._embeddedEngineStateMap.entrySet()) {
            Thread entryThread;
            if (this.isCompleted(embEngineStateEntry.getValue()) || (entryThread = this._embeddedEngineThreadMap.get(embEngineStateEntry.getKey())) == null || !entryThread.isAlive()) continue;
            while (true) {
                try {
                    embEngineStateEntry.getKey().getControllerProxy().cancel();
                    entryThread.join();
                    continue block2;
                }
                catch (InterruptedException e) {
                    this._logger.log(Level.FINEST, e.getMessage(), e);
                    continue;
                }
                break;
            }
        }
    }

    private boolean isCompleted(WizardState state) {
        return state == WizardState.SHUTTING_DOWN || state == WizardState.TERMINATED;
    }

    public static enum ErrorHandleOption {
        ABORT,
        IGNORE;

    }
}

