/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.tasks;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.helpers.SetTaskHelper;
import com.oracle.cie.wizard.internal.cont.InternalTaskContext;
import com.oracle.cie.wizard.internal.tasks.AbstractInternalTask;
import com.oracle.cie.wizard.internal.wcf.WCFHelper;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;

@TaskDescription(name="evaluateExternalWCF")
public class EvaluateExternalWCF
extends AbstractInternalTask {
    private String _wcfFilePath;
    private String _prefix = "";
    private String[] _targetNames;
    private boolean _abortOnError;
    private SetTaskHelper.Target _target = SetTaskHelper.Target.workflow;
    private static final String AVAILABILITY_SUFFIX = "_available";

    @TaskAttribute(required=true, type=TaskAttributeType.LITERAL)
    public void setWcfFilePath(String wcfFilePath) {
        this._wcfFilePath = wcfFilePath;
    }

    @TaskAttribute(required=true, type=TaskAttributeType.LITERAL)
    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"objectstore", "workflow", "os_wf"}, defaultValue="workflow")
    public void setTarget(String target) {
        try {
            this._target = SetTaskHelper.Target.valueOf(target);
        }
        catch (Exception ex) {
            this._logger.warning("Unsupported target: " + target + ". Supported values: " + Arrays.toString((Object[])SetTaskHelper.Target.values()));
        }
    }

    @TaskAttribute(required=false, type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setAbortOnError(String abortOnError) {
        this._abortOnError = Boolean.valueOf(abortOnError);
    }

    @TaskAttribute(required=false, type=TaskAttributeType.LITERAL)
    public void setTargetNames(String targetNames) {
        if (!StringUtil.isNullOrEmpty((String)targetNames, (boolean)true)) {
            this._targetNames = targetNames.split(",");
        }
    }

    @Override
    public void execute() throws TaskExecutionException {
        block9: {
            WCFHelper wcfHelper;
            String prefix;
            block8: {
                String wcfFilePath = ((InternalTaskContext)this._context).substitute(this._namespace, this._wcfFilePath);
                prefix = ((InternalTaskContext)this._context).substitute(this._namespace, this._prefix);
                if (((InternalTaskContext)this._context).getProxy().getTaskClassLoader().getResource(wcfFilePath) == null) {
                    this._logger.log(Level.INFO, "No extension file: " + wcfFilePath + " available in classpath.");
                    return;
                }
                WCFFileValidationEventHandler wcfFileValidationEH = new WCFFileValidationEventHandler();
                wcfHelper = null;
                try {
                    wcfHelper = new WCFHelper(wcfFilePath, wcfFileValidationEH, ((InternalTaskContext)this._context).getProxy().getTaskClassLoader());
                    SetTaskHelper.setKeyOnTarget(this._context, this._namespace, this._target, prefix.concat(AVAILABILITY_SUFFIX), "true");
                }
                catch (ExecPlanException e) {
                    this._logger.log(Level.WARNING, "Error occurred while parsing " + wcfFilePath, e);
                    for (String prob : wcfFileValidationEH.getWcfProblems()) {
                        this._logger.log(Level.WARNING, prob);
                    }
                    if (!this._abortOnError) break block8;
                    throw new TaskExecutionException(this, MessageFormat.format(((InternalTaskContext)this._context).getI18nString("wizard", "LoadObjectStoreTask.error.msg"), wcfFilePath));
                }
            }
            if (wcfHelper == null) break block9;
            Set<String> wcfTargetNames = wcfHelper.getTargets();
            if (this._targetNames != null && this._targetNames.length > 0) {
                for (String tName : this._targetNames) {
                    if (!wcfTargetNames.contains(tName = ((InternalTaskContext)this._context).substitute(tName.trim()))) continue;
                    SetTaskHelper.setKeyOnTarget(this._context, this._namespace, this._target, prefix + "_" + tName + AVAILABILITY_SUFFIX, true);
                }
            } else {
                for (String targetName : wcfTargetNames) {
                    SetTaskHelper.setKeyOnTarget(this._context, this._namespace, this._target, prefix + "_" + targetName + AVAILABILITY_SUFFIX, true);
                }
            }
        }
    }

    private static class WCFFileValidationEventHandler
    implements ValidationEventHandler {
        Set<String> wcfProblemSet = new HashSet<String>();

        private WCFFileValidationEventHandler() {
        }

        public boolean handleEvent(ValidationEvent ve) {
            ValidationEventLocator vel = ve.getLocator();
            String wcfMsg = "[" + vel.getURL() + " - line:" + vel.getLineNumber() + ", column:" + vel.getColumnNumber() + "] " + ve.getMessage();
            switch (ve.getSeverity()) {
                case 1: 
                case 2: {
                    this.wcfProblemSet.add(wcfMsg);
                    break;
                }
            }
            return true;
        }

        public Set<String> getWcfProblems() {
            return this.wcfProblemSet;
        }
    }
}

