/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.tasks;

import com.oracle.cie.wizard.internal.cont.InternalTaskContext;
import com.oracle.cie.wizard.internal.tasks.AbstractInternalTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.text.MessageFormat;
import java.util.logging.Level;

@TaskDescription(name="newInstance", cachingPolicy=TaskCachingPolicy.REUSE)
public class CreateInstanceTask
extends AbstractInternalTask {
    private String _classname = null;
    private String _key = null;

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY, required=true)
    public void setKey(String key) {
        this._key = key;
    }

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"java.lang.Object"}, required=true)
    public void setClass(String classname) {
        this._classname = classname;
    }

    @Override
    public void execute() throws TaskExecutionException {
        try {
            ClassLoader loader = ((InternalTaskContext)this._context).getProxy().getTaskClassLoader();
            Class<?> clazz = loader.loadClass(((InternalTaskContext)this._context).substitute(this._namespace, this._classname));
            Object obj = clazz.newInstance();
            ((InternalTaskContext)this._context).storeObject(this._namespace, ((InternalTaskContext)this._context).substitute(this._namespace, this._key), obj);
        }
        catch (Exception x) {
            String msg;
            this._logger.log(Level.SEVERE, "Unable to instantiate class: " + this._classname, x);
            try {
                msg = MessageFormat.format(((InternalTaskContext)this._context).getI18nString("wizard", "CreateInstanceTask.error.instantiate.text"), this._classname);
            }
            catch (Exception ignore) {
                msg = "Unable to instantiate class: " + this._classname;
            }
            throw new TaskExecutionException(this, msg, x);
        }
    }

    @Override
    public void unconfigure() {
        this._classname = null;
        this._key = null;
    }
}

